% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plorn.R
\name{plorn}
\alias{plorn}
\title{Construct and apply the PLORN model with your own data}
\usage{
plorn(x, y, newx = x, method = "linear", lower.thr = 0, n.pred = 0)
}
\arguments{
\item{x}{A data matrix (row: samples, col: predictors).}

\item{y}{A vector of an environment in which the samples were collected.}

\item{newx}{A data matrix (row: samples, col: predictors).}

\item{method}{A string to specify the method of regression for calculating R-squared values.
"linear" (default), "quadratic" or "cubic" regression model can be specified.}

\item{lower.thr}{The lower threshold of R-squared value to be used in PLORN model (default: 0).}

\item{n.pred}{The number of candidate predictors to be used in PLORN model (default: 30).}
}
\value{
A vector of the environment in which the samples of newx were collected
}
\description{
Construct and apply the PLORN model with your own data
}
\examples{
data(Pinus)
train <- p.clean(Pinus$train)
test <- Pinus$test
test <- test[, colnames(train)]
target <- Pinus$target
cor(target, plorn(train, target, newx = test, method = "cubic"))
}
\author{
Takahiko Koizumi
}
