% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.R
\name{corr}
\alias{corr}
\title{Correlation Analysis}
\usage{
corr(datap, verbose = FALSE)
}
\arguments{
\item{datap}{The data set}

\item{verbose}{If \code{verbose = TRUE} then some results are
printed in the console.}
}
\value{
Returns a list of two objects:
\describe{
\item{Correlations}{the data frame of Pearson's correlation coefficients}
\item{P_values}{the data frame of significance of correlation coefficients (r):}
\itemize{
\item{\code{p} p-value for testing the r}
\item{\code{lowCI} lower confidence interval of r}
\item{\code{uppCI} upper confidence interval of r}
}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
\itemize{
\item \code{corr()} estimates Pearson correlation coefficients
among parametric numerical characteristics as follows:
\item \verb{The Pearson correlation coefficient:}
\loadmathjax
\mjsdeqn{
r_{x,y} = \frac{n\sum{xy}-(\sum{x})(\sum{y})}
{\sqrt{(n\sum{x^2}-(\sum{x})^2)(n\sum{y^2}-(\sum{y})^2)}}}
}

or:
\mjsdeqn{
r_{x,y} =\frac{\Sigma(x-\bar{x})(y-\bar{y})}
{\sqrt{\Sigma{(x-\bar{x})^2\Sigma(y-\bar{y}})^2}} }

where \mjseqn{r_{x,y}} is the \verb{correlation coefficient}
between \mjseqn{x} and \mjseqn{y} variables.
}
\details{
The \code{corr()} function estimates correlation coefficients
and their significance in the form of a table of one or
more independent (exogenous) variables on a dependent
(endogenous) variable along with testing the significance.
}
\examples{
\donttest{
data(dtsimp)
corr(dtsimp, verbose = FALSE)
}
\donttest{
data(dtraw)
corr(dtraw[, -1], verbose = FALSE)
}
}
\seealso{
\code{correlation}
}
\author{
{
Ali Arminian \href{mailto:abeyran@gmail.com}{abeyran@gmail.com}
}
}
