% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uploadToDatabase.R
\name{createPlpResultTables}
\alias{createPlpResultTables}
\title{Create the results tables to store PatientLevelPrediction models and results into a database}
\usage{
createPlpResultTables(
  connectionDetails,
  targetDialect = "postgresql",
  resultSchema,
  deleteTables = TRUE,
  createTables = TRUE,
  tablePrefix = "",
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  testFile = NULL
)
}
\arguments{
\item{connectionDetails}{The database connection details}

\item{targetDialect}{The database management system being used}

\item{resultSchema}{The name of the database schema that the result tables will be created.}

\item{deleteTables}{If true any existing tables matching the PatientLevelPrediction result tables names will be deleted}

\item{createTables}{If true the PatientLevelPrediction result tables will be created}

\item{tablePrefix}{A string that appends to the PatientLevelPrediction result tables}

\item{tempEmulationSchema}{The temp schema used when the database management system is oracle}

\item{testFile}{(used for testing) The location of an sql file with the table creation code}
}
\value{
Returns NULL but creates or deletes the required tables in the specified database schema(s).
}
\description{
This function executes a large set of SQL statements to create tables that can store models and results
}
\details{
This function can be used to create (or delete) PatientLevelPrediction result tables
}
\examples{
\dontshow{if (rlang::is_installed("RSQLite")) withAutoprint(\{ # examplesIf}
# create a sqlite database with the PatientLevelPrediction result tables
connectionDetails <- DatabaseConnector::createConnectionDetails(
  dbms = "sqlite",
  server = file.path(tempdir(), "test.sqlite"))
createPlpResultTables(connectionDetails = connectionDetails,
                      targetDialect = "sqlite",
                      resultSchema = "main",
                      tablePrefix = "plp_")
# delete the tables
createPlpResultTables(connectionDetails = connectionDetails,
                      targetDialect = "sqlite",
                      resultSchema = "main",
                      deleteTables = TRUE,
                      createTables = FALSE,
                      tablePrefix = "plp_")
# clean up the database file
unlink(file.path(tempdir(), "test.sqlite"))
\dontshow{\}) # examplesIf}
}
