% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_matching_functions.R
\name{convert_to_regex_pattern}
\alias{convert_to_regex_pattern}
\title{Convert Peptide Sequence to Regex Pattern}
\usage{
convert_to_regex_pattern(peptide)
}
\arguments{
\item{peptide}{A character string representing the peptide sequence.}
}
\value{
A character string containing the regex pattern for matching.
}
\description{
This function converts a peptide sequence into a regular expression pattern
that accounts for ambiguous amino acids. Each amino acid is replaced by a
character class that includes itself, 'X', and any specific ambiguities.
}
\examples{
# Convert a peptide sequence to a regex pattern
peptide <- "NDEQIL"
regex_pattern <- convert_to_regex_pattern(peptide)
print(regex_pattern) # Output: "[NBX][DBX][EZX][QZX][ILX][ILX]"
}
