% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addnetwork.R
\name{addnetwork}
\alias{addnetwork}
\title{Create a social network for people in a population}
\usage{
addnetwork(
  people,
  pplid,
  pplage,
  netmax,
  sdused = 0,
  probsame = 0.5,
  userseed = NULL,
  numiters = 1e+06,
  usematrix = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{people}{A data frame containing people to be matched to each other using social networks.}

\item{pplid}{The variable for each person's unique ID.}

\item{pplage}{The variable for each person's age.}

\item{netmax}{A data frame containing the 1-dimensional matrix of network sizes. Must contain only integers and be the same length as the people data frame.}

\item{sdused}{The standard deviation for the age differences between two people.}

\item{probsame}{The probability that a friend of a friend is also a friend. For example, if A and B and friends, and B and C are friends, this is the probability that C is also a friend of A.}

\item{userseed}{The user-defined seed for reproducibility. If left blank, the normal set.seed() function will be used.}

\item{numiters}{The maximum number of iterations used to construct the coupled data frame. This has a default value of 100, and is the stopping rule if the algorithm does not converge.}

\item{usematrix}{If an adjacency matrix is output instead of an igraph object. Default is FALSE so an igraph object is output. If TRUE is used, the n x n dgCMatrix is output.}

\item{verbose}{Whether a notification is printed to the console if the number of contacts must be increased by one. Notification is that it has occurred, where the value has been increased, and the original and new number of contacts. The default is FALSE, so no information will be printed to the console.}
}
\value{
Either an igraph of social networks, or a dgCMatrix of n x n.
}
\description{
Creates social networks between people, based on age differences. A data frame of people with ages is required. These are the people who will have social relationships between each other. A a 1x n matrix of counts must also be supplied, where n is the number of rows in the people data frame. As person-to-person pairs are constructed, the sum of the matrix counts must be even. If it is not, the function will randomly select one person's social network size from the matrix and add 1 to it. If this correction happens, an explanation, including the index position of the count, will be printed to the console.
}
\details{
A normal distribution is used, using the age differences between the pairs. This is centred on 0, i.e. the people in the pair are the same age. If people B and C are in person A's network, the value of probsame is used to determine the likelihood that people B and C know each other. The larger this probability, the more likely that people in one person's network know each other, compared to random construction of a network between them.

The two options for output are a dgCMatrix or an igraph. The dgCMatrix is output as n x n. For a large data frame of people, this will be a large and sparse matrix, which may not be completed due to RAM limitations. The igraph output only contains the pairs, and should be a smaller object compared to the dgCMatrix.
}
\examples{

library("dplyr")

# smaller sample for visualisation
set.seed(2) # small datasets can cause problems if a random seed is used for sampling
 SmallDemo <- Township \%>\%
  filter(between(Age, 20, 29)) \%>\%
  slice_sample(n = 20)
  Smallnetwork <- rpois(n = nrow(SmallDemo), lambda = 1.5)
  NetworkSmallN <- addnetwork(SmallDemo, "ID", "Age", Smallnetwork, sdused=2,
                              probsame = .5, userseed=4, numiters = 10)
 # plot(NetworkSmallN)
}
