% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/german_credit_loader.R
\name{get_german_credit_dataset}
\alias{get_german_credit_dataset}
\title{Load and pre-process the dataset that ships with the package}
\usage{
get_german_credit_dataset(
  scale = TRUE,
  add_constant_term = TRUE,
  download_destination = NULL
)
}
\arguments{
\item{scale}{Whether to scale the features to have mean 0 and variance 1.}

\item{add_constant_term}{Whether to add a constant term as the first feature.}

\item{download_destination}{Provide a filepath if you want to download the
dataset from source. Note that although the original dataset has 20
features (some of them qualitative), the numeric dataset has 24 features.}
}
\value{
A list with fields \code{x} for features and \code{y} for outcomes.
}
\description{
Load and pre-process the dataset that ships with the package
}
\examples{
\donttest{
german <- get_german_credit_dataset()
head(german$y)
head(german$x)
}

}
