% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest.R
\name{quest}
\alias{quest}
\title{Construct and apply the QuEST model with your own data}
\usage{
quest(x, y, newx = x, method = "linear", lower.thr = 0, n.gene = 0)
}
\arguments{
\item{x}{A data matrix (row: samples, col: genes).}

\item{y}{A vector of an environment in which the samples were collected.}

\item{newx}{A data matrix (row: samples, col: genes).}

\item{method}{A string to specify the method of regression for calculating R-squared values.
"linear" (default), "quadratic" or "cubic" regression model can be specified.}

\item{lower.thr}{The lower threshold of R-squared value to be used in QuEST model (default: 0).}

\item{n.gene}{The number of candidate genes to be used in QuEST model (default: 30).}
}
\value{
A vector of the environment in which the samples of newx were collected
}
\description{
Construct and apply the QuEST model with your own data
}
\examples{
data(Pinus)
train <- q.clean(Pinus$train)
test <- Pinus$test
test <- test[, colnames(train)]
target <- Pinus$target
cor(target, quest(train, target, newx = test, method = "cubic"))
}
\author{
Takahiko Koizumi
}
