% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ransac_reg.R
\name{ransac_reg}
\alias{ransac_reg}
\title{Robust Linear Model Fitting via RANSAC}
\usage{
ransac_reg(formula, data, n_min, n_iter = 100, tol = 0.2, verbose = FALSE)
}
\arguments{
\item{formula}{Model formula (as in `lm`).}

\item{data}{Data frame containing the model variables.}

\item{n_min}{Minimum number of points to fit the model (e.g., 2 for a straight line).}

\item{n_iter}{Number of iterations (higher values make the model more robust).}

\item{tol}{Absolute tolerance to consider a point as an inlier.}

\item{verbose}{If `TRUE`, shows progress messages.}
}
\value{
An `lm` model fitted only to the inliers, with an additional class `"ransac_model"` and an `"inliers"` attribute.
}
\description{
Fits a robust linear model (`lm`) using the RANSAC algorithm.
}
\examples{
set.seed(123)
x <- 1:10
y <- c(1, 2, 3, 4, 5, 6, 7, 8, 50, 60) # some outliers
data <- data.frame(x = x, y = y)
model <- ransac_reg(y ~ x, data = data, n_min = 2, tol = 5)
summary(model)

}
