% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REFA.R
\name{REFA}
\alias{REFA}
\title{Robust Exponential Factor Analysis}
\usage{
REFA(Y, r = 3, tau = 0.75, q = 0.05, eps = 1e-05, init = TRUE)
}
\arguments{
\item{Y}{Input matrix, of dimension \eqn{T\times N}. Each row is an observation with \eqn{N} features at time point \eqn{t}.}

\item{r}{A positive integer indicating the factor numbers.}

\item{tau}{Hyper parameter in selecting \eqn{\gamma} of the loss function.}

\item{q}{Hyper parameter used in the initializations, truncated PCA.}

\item{eps}{The stopping criterion parameter. The default is 1e-5.}

\item{init}{Warm start of the algorithm. If \code{init = TRUE}, use truncated PCA initialization. If \code{init} is a list contains \code{F0} and \code{L0}, we will use this initialization. Otherwise, use traditional PCA initialization.}
}
\value{
A list containing:
\item{Fhat}{The estimated factor matrix.}
\item{Lhat}{The estimated loading matrix.}
\item{loss}{The value of the loss function.}
}
\description{
Robust Exponential Factor Analysis
}
\examples{
\donttest{
# Assuming gendata() is defined in your package
dat = gendata()
REFA(dat$Y, r = 3)
}
}
\references{
Robust factor analysis with exponential squared loss. Jiaqi Hu, Tingyin Wang, Xueqin Wang. Journal of Multivariate Analysis 2026, 213 105567; doi:10.1016/j.jmva.2025.105567
}
\author{
Jiaqi Hu
}
