% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newPresentation.R
\name{newPresentation}
\alias{newPresentation}
\alias{introPresentation}
\title{Create a new presentation}
\usage{
newPresentation(fileName, width = NULL, height = NULL, border = "*",
  padding = 1, slideSep = rep("", 3))

introPresentation()
}
\arguments{
\item{fileName}{(character) the file containing the presentation. Currently
one of: .Rmd, md, or plain.}

\item{width}{(integer) the number of columns to use. By default:
\code{options('width')}.}

\item{height}{(integer) the number of rows to use. By default set to 22.}

\item{border}{(character) the character used as a border to frame a single
slide.}

\item{padding}{(integer) the number of white-spaces / empty rows between
border and content.}

\item{slideSep}{(character) the slide separator: how to determine a 'slide
break'.}
}
\value{
The function returns an instance of the presentation. It has only one
  method: \code{start} without any arguments. \code{start} will start the
  presentation and also resume where you left.
}
\description{
Creates a new instance of a presentation. Currently it has only one method:
\code{start} which is called without any arguments. It starts a presentation
or resumes where you left off. A presentation runs inside your R console and
the idea is to maximize the window on your screen for a presentation mode.
}
\details{
To convert from Rmd to md formats \code{knitr::knit} is used. To convert from
  md to plain \code{knitr::pandoc(file, format = "plain")} is used. If you
  want to configure the process of this conversion please see the
  documentation of these two functions.

For navigation inside the presentation mode, please see the examples below.
  Or start a presentation and type 'h' for help.
}
\examples{
\dontrun{
## Start with the example:
introPresentation() # in presentation mode type 'h'

## The same presentation but with manual configuration:
file <- system.file("Introduction.Rmd", package = "REPLesentR")
myPresentation <- newPresentation(
  file, width = 80, height = 23, border = "O", padding = 1)
myPresentation$start()
}
}
