% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gap.R
\name{gapProd}
\alias{gapProd}
\title{Production function output gap}
\usage{
gapProd(
  tsl,
  NAWRUfit,
  TFPfit,
  alpha = 0.65,
  start = NULL,
  end = NULL,
  lambda = NULL
)
}
\arguments{
\item{tsl}{A list of time series objects, see details.}

\item{NAWRUfit}{An object of class \code{NAWRUfit} obtained via the function \code{fit}.}

\item{TFPfit}{An object of class \code{TFPfit} obtained via the function \code{fit}.}

\item{alpha}{A scalar between zero and one depicting the labor share. The default is
\code{alpha = 0.65}.}

\item{start}{(optional) A two element vector containing a year and a period specifying
the start point for the estimation.}

\item{end}{(optional) A two element vector containing a year and a period specifying the
end point for the estimation.}

\item{lambda}{The smoothing parameter for the application of the HP filter (see details).
If not supplied, \code{lambda = 6.25} for yearly data, \code{lambda = 1600} for quarterly
data, and \code{lambda = 129600} for monthly data.}
}
\value{
Object of class \code{gap}, which is a list with the following components:
  \item{tsl}{List of time series including potential output \code{potential}, the
  output gap \code{gap}, all HP-filtered trend series, and all original series.}
  \item{NAWRUfit}{Provided \code{NAWRUfit} object.}
  \item{TFPfit}{Provided \code{TFPfit} object.}
  \item{call}{Original call to the function.}
}
\description{
Computes potential output and the output gap based on a production function
  methodology.
}
\details{
The list of time series \code{tsl} needs to have the following components:
\describe{
  \item{lfnd}{Labor force non-domestic (unit: 1000 persons). (Set to zero if left unspecified).}
  \item{parts}{Participation rate.}
  \item{ahours}{Average hours worked (unit: hours).}
  \item{gdp}{Gross domestic product at constant prices (unit: bn National currency, code: OVGD).}
  \item{k}{Net capital stock at constant prices: total economy (unit: bn National currency, code: OKND).}
  \item{popw}{Population: 15 to 64 years (unit: 1000 persons, code: NPAN).}
  }

The trend of the list components \code{parts, ahours and lfnd} (if available)
  is computed using the Hodrick-Prescott filter with the smoothing constant
  \code{lambda}, unless the supplied time series list \code{tsl} contains their trend 
  (for instance, denoted by \code{partsTrend}).
}
\examples{
# compute the output gap given the previously obtained nawru and trend tfp
data("gap")
country <- "Belgium"
tsList <- amecoData2input(gap[[country]])
modelNAWRU <- NAWRUmodel(tsl = tsList)
modelTFP <- TFPmodel(tsl = tsList, cycle = "RAR2")

\donttest{
fittedNAWRU <- fit(model = modelNAWRU)
fittedTFP <- fit(model = modelTFP)

gapProd(tsl = tsList, NAWRUfit = fittedNAWRU, TFPfit = fittedTFP)
}
}
