% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GreenplumConnection.R
\docType{methods}
\name{dbConnect,GreenplumDriver-method}
\alias{dbConnect,GreenplumDriver-method}
\title{Connect to a Greenplum database.}
\usage{
\S4method{dbConnect}{GreenplumDriver}(drv, dbname = NULL, host = NULL,
  port = NULL, password = NULL, user = NULL, service = NULL, ...,
  bigint = c("integer64", "integer", "numeric", "character"))
}
\arguments{
\item{drv}{`RGreenplum::Greenplum()`}

\item{dbname}{Database name. If `NULL`, defaults to the user name.
Note that this argument can only contain the database name, it will not
be parsed as a connection string (internally, `expand_dbname` is set to
`false` in the call to
[`PQconnectdbParams()`](https://www.postgresql.org/docs/9.6/static/libpq-connect.html)).}

\item{host, port}{Host and port. If `NULL`, will be retrieved from
`PGHOST` and `PGPORT` env vars.}

\item{user, password}{User name and password. If `NULL`, will be
retrieved from `PGUSER` and `PGPASSWORD` envvars, or from the
appropriate line in `~/.pgpass`. See
<http://www.postgresql.org/docs/9.6/static/libpq-pgpass.html> for
more details.}

\item{service}{Name of service to connect as.  If `NULL`, will be
ignored.  Otherwise, connection parameters will be loaded from the pg_service.conf
file and used.  See <http://www.postgresql.org/docs/9.6/static/libpq-pgservice.html>
for details on this file and syntax.}

\item{...}{Other name-value pairs that describe additional connection
options as described at
<http://www.postgresql.org/docs/9.6/static/libpq-connect.html#LIBPQ-PARAMKEYWORDS>}

\item{bigint}{The R type that 64-bit integer types should be mapped to,
default is [bit64::integer64], which allows the full range of 64 bit
integers.}
}
\description{
Manually disconnecting a connection is not necessary with RGreenplum, but
still recommended;
if you delete the object containing the connection, it will be automatically
disconnected during the next GC with a warning.
}
