% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning_kernels.R
\name{GenerateClusterData}
\alias{GenerateClusterData}
\title{Generates clusters from multivariate normal distributions}
\usage{
GenerateClusterData(numberOfFeatures, numberOfVectorsPerCluster,
  numberOfClusters = 2 * numberOfFeatures + 1)
}
\arguments{
\item{numberOfFeatures}{the number of features, the dimension of the feature
space}

\item{numberOfVectorsPerCluster}{the number of vectors to randomly generate
for each cluster}

\item{numberOfClusters}{the number of clusters to be generated.  The value
of this parameter must be in the interval [1,2*\code{numberOfFeatures}+1]}
}
\value{
a list containing a matrix of feature vectors \code{featureVectors}
  as rows of feature vectors,
  number of features \code{numberOfFeatures}, number of feature vectors
  \code{numberOfFeatureVectors}, and number of clusters
  \code{numberOfClusters}.
}
\description{
\code{GenerateClusterData} generates clusters of feature vectors drawn
from multivariate normal (MVN) distributions.  The mean values of the normal
distribution corresponding to the first cluster is always at the origin. 
The remaining clusters are generated from MVN distributions with mean values
at v_i and -v_i where v_i is the i-th unit vector.  The clusters are
generated in the following order by mean value of the MVN for each cluster:
origin, v_1, -v_1, v_2, -v_2, v_3, -v_3,..., v_{(numberOfClusters-1)/2},
-v_{(numberOfClusters-1)/2} (if \code{numberOfClusters} is odd)
origin, v_1, -v_1, v_2, -v_2, v_3, -v_3,..., v_{(numberOfClusters-1)/2}
(if \code{numberOfClusters} is even).
}
