% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microbenchmark_dense_matrix_kernel.R
\name{MicrobenchmarkDenseMatrixKernel}
\alias{MicrobenchmarkDenseMatrixKernel}
\title{Performs microbenchmarking of a dense matrix linear algebra kernel}
\usage{
MicrobenchmarkDenseMatrixKernel(benchmarkParameters, numberOfThreads,
  resultsDirectory, runIdentifier)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{DenseMatrixMicrobenchmark}} specifying the matrix
dimensions of matrices to be tested and the number of performance trials
to perform for each matrix dimension.}

\item{numberOfThreads}{the number of threads the microbenchmark is being
performed with.  The value is for informational purposes only and does not
effect the number threads the kernel is executed with.}

\item{resultsDirectory}{a character string specifying the directory
where all of the CSV performance results files will be saved}

\item{runIdentifier}{a character string specifying the suffix to be
appended to the base of the file name of the output CSV format files}
}
\value{
a dataframe containing the performance trial times for each matrix
  tested, that is the raw performance data before averaging.  The columns
  of the data frame are the following:
  \describe{
    \item{BenchmarkName}{The name of the microbenchmark}
    \item{DimensionParameter}{The dimension parameters the microbenchmark
       uses to define the matrix dimensions to be tested with}
    \item{UserTime}{The amount of time spent in user-mode code within the
       microbenchmarked code}
    \item{SystemTime}{The amount of time spent in the kernel within the
       process}
    \item{WallClockTime}{The total time spent to complete the performance
       trial}
    \item{DateStarted}{The date and time the performance trial was commenced}
    \item{DateFinished}{The date and time the performance trial ended}
  }
}
\description{
\code{MicrobenchmarkDenseMatrixKernel} performs microbenchmarking of a
dense matrix linear algebra kernel for several matrix dimensions
}
\details{
This function performs microbenchmarking of a dense matrix linear algebra
kernel for several matrix dimensions and a given number of threads.  The
kernel to be performance tested, the matrix dimensions to be tested, and
other parameters specifying how the kernel is to be benchmarked are given in
the input object \code{benchmarkParameters} which is an instance of
the class \code{\link{DenseMatrixMicrobenchmark}}.  For each matrix dimension
to be tested, the run time performance of the kernel is averaged over
multiple performance trials, and the averages are written to a CSV file.  The
results of the individual performance trials are retained in a data frame
that is returned upon completion of the microbenchmark.  The kernel can also
be executed with multiple threads if the kernel supports multithreading.  See
\code{\link{DenseMatrixMicrobenchmark}} for more details on the benchmarking
parameters.
}
