% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dense_matrix_benchmark.R
\name{RunDenseMatrixBenchmark}
\alias{RunDenseMatrixBenchmark}
\title{Runs all of the dense matrix microbenchmarks}
\usage{
RunDenseMatrixBenchmark(runIdentifier, resultsDirectory,
  microbenchmarks = GetDenseMatrixDefaultMicrobenchmarks())
}
\arguments{
\item{runIdentifier}{a character string specifying the suffix to be
appended to the base of the file name of the output CSV format files}

\item{resultsDirectory}{a character string specifying the directory
where all of the CSV performance results files will be saved}

\item{microbenchmarks}{a list of \code{DenseMatrixMicrobenchmark} objects
defining the microbenchmarks to execute as part of the dense matrix
benchmark.  Default values are provided by the function
\code{\link{GetDenseMatrixDefaultMicrobenchmarks}}.}
}
\value{
a data frame containing the benchmark name, 
  user, system, and elapsed (wall clock) times of each performance trial
  for each microbenchmark
}
\description{
\code{RunDenseMatrixBenchmark} runs all of the microbenchmarks for
  performance testing the dense matrix linear algebra kernels
}
\details{
This function runs all of the dense matrix microbenchmarks defined in the
\code{microbenchmarks} input list for which the \code{active} field is 
set to TRUE.  For each microbenchmark, it attempts to create a
separate output file in CSV format containing the performance results for
each matrix tested by the microbenchmark.  The names of the output files
follow the format \code{benchmarkName}_\code{runIdentifier}.csv,
where \code{benchmarkName} is specified in the
\code{DenseMatrixMicrobenchmark} object of each microbenchmark, and
\code{runIdentifier} is an input parameter to this function.  If the file
already exists, the results will be appended to the existing file.  The
\code{microbenchmarks} input list
contains instances of the \code{DenseMatrixMicrobenchmark} class defining
each microbenchmark.  The default microbenchmarks are generated by the
function \code{\link{GetDenseMatrixDefaultMicrobenchmarks}}.  If the
linear algebra kernels are multithreaded, by linking to multithreaded
BLAS or LAPACK libraries for example, then the number of threads must
be retrievable from an environment variable which is set before execution of
the R programming environment.  The name of the environment variable
specifying the number of threads must be provided in the R HPC benchmark
environment variable R_BENCH_NUM_THREADS_VARIABLE.  This function will
retrieve the number of threads through R_BENCH_NUM_THREADS_VARIABLE so that
the number of threads can be printed to the results files and recorded in
data frames for reporting purposes.  This function utilizes the number of
threads only for reporting purposes and is not used by the benchmark to
effect the actual number of threads utilized by the kernels, as that is
assumed to be controlled by the numerical library.  An error exception will
be thrown if the environment variable R_BENCH_NUM_THREADS_VARIABLE and the
variable it is set to are not both set.
}
\examples{
\dontrun{
# Set needed environment variables for multithreading.  Only single threading
# is used in the example.
#
# Note: The environment variables are usually set by the user before starting
#       the R programming environment; they are set here only to facilitate
#       a working example.  See the section on multithreading in the vignette
#       for further details.
Sys.setenv(R_BENCH_NUM_THREADS_VARIABLE="MKL_NUM_THREADS")
Sys.setenv(MKL_NUM_THREADS="1")
#
# Generate example microbechmarks that can be run in a few minutes; see
# the vignette for more involved examples.  The Cholesky factorization and
# matrix crossproduct microbenchmarks are performed in the example code
# below.
#
# Note: These microbenchmarks are different than the microbenchmarks
#       generated by \\code{\\link{GetDenseMatrixDefaultMicrobenchmarks}}.
#       They are chosen for their short run times and suitability for
#       example code. 
exampleMicrobenchmarks <- GetDenseMatrixExampleMicrobenchmarks()
# Set the output directory of the CSV summary results files
resultsDirectory <- "./DenseMatrixExampleOutput"
# Create the output directory
dir.create(resultsDirectory)
# Set an appropriate run identifier
runIdentifier <- "example"
resultsFrame <- RunDenseMatrixBenchmark(runIdentifier, resultsDirectory,
   microbenchmarks=exampleMicrobenchmarks)

# This example runs all but the matrix transpose microbenchmarks.
exampleMicrobenchmarks[["transpose"]]$active <- FALSE
# Set an appropriate run identifier
runIdentifier <- "no_transpose"
exTransposeResultsFrame <- RunDenseMatrixBenchmark(runIdentifier,
  resultsDirectory, microbenchmarks=exampleMicrobenchmarks)

# This example runs only the matrix-matrix multiplication microbenchmark,
# and it adds a larger matrix to test.
matMatMicrobenchmark <- list()
matMatMicrobenchmark[["matmat"]] <- GetDenseMatrixExampleMicrobenchmarks()[["matmat"]]
matMatMicrobenchmark[["matmat"]]$dimensionParameters <- as.integer(c(1000, 2000))
matMatMicrobenchmark[["matmat"]]$numberOfTrials <- as.integer(c(3, 3))
matMatMicrobenchmark[["matmat"]]$numberOfWarmupTrials <- as.integer(c(1, 1))
# Set an appropriate run identifier
runIdentifier <- "matmat"
matMatResults <- RunDenseMatrixBenchmark(runIdentifier, resultsDirectory,
   microbenchmarks=matMatMicrobenchmark)
}

}
\seealso{
\code{\link{GetDenseMatrixDefaultMicrobenchmarks}}
         \code{\link{GetDenseMatrixExampleMicrobenchmarks}}
}
