% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OCRA.R
\name{apply.OCRA}
\alias{apply.OCRA}
\title{Apply Operational Competitiveness Rating (OCRA) method}
\usage{
apply.OCRA(mat, weights, beneficial.vector)
}
\arguments{
\item{mat}{A numeric matrix. Rows are alternatives; columns are criteria.}

\item{weights}{A numeric vector of weights corresponding to criteria columns. Must sum to 1.}

\item{beneficial.vector}{A numeric vector containing the column indices of beneficial
(profit) criteria. Non-beneficial criteria are assumed to be the remaining columns.}
}
\value{
A numeric vector with the OCRA preference values for each alternative.
Higher values indicate a more preferred alternative.
}
\description{
The OCRA method independently evaluates alternatives with respect to beneficial
(profit) and non-beneficial (cost) criteria, then combines these evaluations into
an overall operational competitiveness rating.
}
\examples{
mat <- matrix(c(
  7.7, 256, 7.2, 7.3, 7.3,
  8.1, 250, 7.9, 7.8, 7.7,
  8.7, 352, 8.6, 7.9, 8.0,
  8.1, 262, 7.0, 8.1, 7.2,
  6.5, 271, 6.3, 6.4, 6.1,
  6.8, 228, 7.1, 7.2, 6.5
), nrow = 6, byrow = TRUE)

weights <- c(0.239, 0.225, 0.197, 0.186, 0.153)
beneficial.vector <- c(1, 3, 4, 5)

apply.OCRA(mat, weights, beneficial.vector)
}
