% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate.map.R
\name{rate.map}
\alias{rate.map}
\title{Mapping rate and direction of phenotypic change on 3D surfaces.}
\usage{
rate.map(x, RR, scores, pcs, mshape, mshape_sur=NULL,refsur=NULL,
  refmat=NULL, k=4,out.rem = TRUE, plot=TRUE, pal=NULL,
  NAcol="gray90",from=NULL, to=NULL,show.names=TRUE)
}
\arguments{
\item{x}{the species/nodes to be compared; it can be a single species, or a
vector containing two species or a species and any of its parental nodes.}

\item{RR}{an object generated by using the \code{\link[RRphylo]{RRphylo}}
function.}

\item{scores}{RW or PC scores.}

\item{pcs}{RW (or PC) vectors (eigenvectors of the covariance matrix)
returned by RWA/PCA.}

\item{mshape}{the consensus configuration.}

\item{mshape_sur}{a \code{mesh3d} object used as a reference for mesh
reconstruction. The vertices of \code{mshape_sur} must be the consensus
configuration. If \code{NULL}, it is automatically generated by applying
\code{\link[Rvcg]{vcgBallPivoting}} on \code{mshape}.}

\item{refsur}{a list of \code{mesh3d} to be provided for all species in
\code{x}.}

\item{refmat}{a list of landmark sets to be provided for all species in
\code{x}.}

\item{k}{the argument \code{k} passed to \code{\link{interpolMesh}}.}

\item{out.rem}{logical: if \code{TRUE} mesh triangles with outlying area
difference are removed.}

\item{plot}{logical indicating if the 3d plot must be shown.}

\item{pal}{a vector of colors to be passed to
\code{\link[grDevices]{colorRampPalette}}.}

\item{NAcol}{the argument \code{NAcol} passed to \code{\link{col2mesh}}.}

\item{from, to}{lower and upper limits to be associated to the ends of
\code{pal}.}

\item{show.names}{logical: if \code{TRUE}, the names of the species are
displayed in the 3d plot.}
}
\value{
The function returns a list including:
  \itemize{\item\strong{$selected} a list of RWs/PCs axes selected for higher
  evolutionary rates for each species. \item\strong{$surfaces} a list of
  reconstructed colored surfaces of the given species/node and the most recent
  common ancestor.\item\strong{differences} a list area differences
  between corresponding triangles of species reconstructed 3d mesh and the
  surface of the ancestor. \item\strong{lmks} if \code{refmat}
  is not \code{NULL}, this is the landmark configuration rotated on the
  reconstructed surface .}
}
\description{
Given vectors of RW (or PC) scores, the function selects the RW
  (PC) axes linked to highest (and lowest) evolutionary rate values and
  reconstructs the morphology weighted on them. In this way, \code{rate.map}
  shows where and how the phenotype changed the most between any pair of
  taxa.
}
\details{
After selecting the RW (PC) axes, \code{rate.map} automatically
  builds a 3D mesh on the mean shape calculated from the Relative Warp
  Analysis (RWA) or Principal Component Analysis (PCA) (\cite{Schlager 2017})
  by applying the function \code{\link[Rvcg]{vcgBallPivoting}} (\pkg{Rvcg}).
  The reconstruction of species 3d surfaces is based on \code{mshape_sur},
  either provided by the user or generated within the function. Finally, for
  each species in \code{x}, the function computes the area differences
  between corresponding triangles of its reconstructed 3D mesh and the
  surface of the ancestor (most recent common ancestor in the case of two
  species in \code{x}). In the calculation of differences, the possibility to
  find and remove outliers is supplied (\code{out.rem=TRUE}, we suggest
  considering this possibility if the mesh may contain degenerate facets).

  Finally, \code{rate.map} returns a 3D plot showing such comparisons
  displayed on shape of the ancestor/mrca used as the reference. The color
  gradient goes from blue to red, where blue areas represent expansion of the
  mesh, while the red areas represent contraction of the mesh triangles. If a
  list \code{refsur} (and \code{refmat}) is provided, convergence is plotted
  onto them (see \code{\link{interpolMesh}} for further details).
}
\examples{
  \donttest{
  da<-"https://github.com/pasraia/RRmorph_example_data/raw/refs/heads/main/RRmorphdata.rda"
  download.file(url=da,destfile = paste0(tempdir(),"/RRmorphdata.rda"))
  load(paste0(tempdir(),"/RRmorphdata.rda"))

  require(Morpho)
  require(Rvcg)

  pca<-procSym(endo.set)
  ldm_homo<-endo.set[,,"Homo_sapiens"]
  sur_homo<-endo.sur[["Homo_sapiens"]]
  ldm_macaca<-endo.set[,,"Macaca_fuscata"]
  sur_macaca<-endo.sur[["Macaca_fuscata"]]

  cc<- 2/parallel::detectCores()
  RR<-RRphylo::RRphylo(tree.prima,pca$PCscores,clus=cc)

  # plotting on reconstructed surfaces
  Rmap1<-rate.map(x=c("Homo_sapiens","Macaca_fuscata"),RR=RR, scores=pca$PCscores,
                  pcs=pca$PCs, mshape=pca$mshape)

  # plotting on real surfaces
  Rmap2<-rate.map(x=c("Homo_sapiens","Macaca_fuscata"),RR=RR, scores=pca$PCscores,
                  pcs=pca$PCs, mshape=pca$mshape,
                  refsur=list("Homo_sapiens"=sur_homo,"Macaca_fuscata"=sur_macaca),
                  refmat=list("Homo_sapiens"=ldm_homo,"Macaca_fuscata"=ldm_macaca))
  }
}
\references{
Schlager, S. (2017). \emph{Morpho and Rvcg-Shape Analysis in R:
  R-Packages for geometric morphometrics, shape analysis and surface
  manipulations.} In: Statistical shape and deformation analysis. Academic
  Press.

Castiglione, S., Melchionna, M., Profico, A., Sansalone, G.,
  Modafferi, M., Mondanaro, A., Wroe, S., Piras, P., & Raia, P. (2021). Human
  face-off: a new method for mapping evolutionary rates on three-dimensional
  digital models. \emph{Palaeontology}, 65, 1. doi:10.1111/pala.12582

Melchionna, M., Castiglione, S., Girardi, G., Serio, C.,
  Esposito, A., Mondanaro, A., Profico, A., Sansalone, G., & Raia, P. (2024).
  RRmorph—a new R packageto map phenotypic evolutionary rates and patterns on
  3D meshes. \emph{Communications Biology}, 7, 1009.
}
\seealso{
\href{https://CRAN.R-project.org/package=RRphylo/vignettes/RRphylo.html}{\code{RRphylo}
  vignette} ; \code{\link[Morpho]{relWarps}} ; \code{\link[Morpho]{procSym}}
}
\author{
Marina Melchionna, Antonio Profico, Silvia Castiglione, Gabriele
  Sansalone, Pasquale Raia
}
