# RTDE: Robust Tail Dependence Estimation

[![CRAN_Release_Badge](https://www.r-pkg.org/badges/version-ago/RTDE)](https://cran.r-project.org/package=RTDE) [![CRAN Downloads](https://cranlogs.r-pkg.org/badges/RTDE)](https://cran.r-project.org/package=RTDE) [![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)

`RTDE` provides robust tail dependence estimation for bivariate models. This package is based on two papers by the authors: 'Robust and bias-corrected estimation of the coefficient of tail dependence' (<https://doi.org/10.1016/j.insmatheco.2014.05.003>) and 'Robust and bias-corrected estimation of probabilities of extreme failure sets' (<https://doi.org/10.1007/s13171-015-0078-3>).

## The package

The stable version of `RTDE` can be installed from CRAN using:

``` r
install.packages("RTDE")
```

Finally load the package in your current R session with the following R command:

``` r
library(RTDE)
```

## Documentation

Overall documentation is available at

``` r
help(RTDE)
```
