% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barrierSpreadOption.R
\name{barrierSpreadOption}
\alias{barrierSpreadOption}
\title{Barrier Spread Option Pricing}
\usage{
barrierSpreadOption(
  F1 = -12,
  F2 = -3,
  X = 5.5,
  B = 9,
  sigma1 = 0.6,
  sigma2 = 0.6,
  rho = 0.3,
  T2M = 1/12,
  r = 0.045,
  type = "call",
  barrier_type = "uo",
  monitoring = "continuous"
)
}
\arguments{
\item{F1}{numeric, forward price of the first asset (e.g., pipeline origination price as a futures)}

\item{F2}{numeric, forward price of the second asset (e.g., pipeline destination price as a futures)}

\item{X}{numeric, strike price of the spread option}

\item{B}{numeric, barrier level for the spread (F2 - F1)}

\item{sigma1}{numeric, volatility of the first asset (annualized)}

\item{sigma2}{numeric, volatility of the second asset (annualized)}

\item{rho}{numeric, correlation coefficient between the two assets}

\item{T2M}{numeric, time to maturity in years}

\item{r}{numeric, risk-free interest rate (annualized)}

\item{type}{character, "call" or "put"}

\item{barrier_type}{character, "do" or "uo" (down-and-out, up-and-out)}

\item{monitoring}{character, "continuous" or "terminal"}
}
\value{
A list containing option price and Greeks.
}
\description{
This model applies Kirk's (1995) closed-form approximation for pricing spread options,
incorporating barrier adjustments for continuous and terminal monitoring.
}
