% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bccg.R
\name{bccg}
\alias{bccg}
\alias{dbccg}
\alias{pbccg}
\alias{qbccg}
\alias{rbccg}
\title{Box–Cox Cole and Green distribution (BCCG)}
\usage{
dbccg(x, mu = 1, sigma = 0.1, nu = 1, log = FALSE)

pbccg(q, mu = 1, sigma = 0.1, nu = 1, lower.tail = TRUE, log.p = FALSE)

qbccg(p, mu = 1, sigma = 0.1, nu = 1, lower.tail = TRUE, log.p = FALSE)

rbccg(n, mu = 1, sigma = 0.1, nu = 1)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{location parameter, must be positive.}

\item{sigma}{scale parameter, must be positive.}

\item{nu}{skewness parameter (real).}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \le x]}, otherwise \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return}
}
\value{
\code{dbccg} gives the density, \code{pbccg} gives the distribution function, \code{qbccg} gives the quantile function, and \code{rbccg} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the Box–Cox Cole and Green distribution.
}
\details{
This implementation of \code{dbccg} and \code{pbccg} allows for automatic differentiation with \code{RTMB} while the other functions are imported from \code{gamlss.dist} package.
See \code{gamlss.dist::\link[gamlss.dist]{BCCG}} for more details.
}
\examples{
x <- rbccg(5, mu = 10, sigma = 0.2, nu = 0.5)
d <- dbccg(x, mu = 10, sigma = 0.2, nu = 0.5)
p <- pbccg(x, mu = 10, sigma = 0.2, nu = 0.5)
q <- qbccg(p, mu = 10, sigma = 0.2, nu = 0.5)
}
\references{
Rigby, R. A., Stasinopoulos, D. M., Heller, G. Z., and De Bastiani, F. (2019) Distributions for modeling location, scale, and shape: Using GAMLSS in R, Chapman and Hall/CRC,
doi:10.1201/9780429298547. An older version can be found in https://www.gamlss.com/.
}
