% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rw_csv.R
\name{read_rw_csv}
\alias{read_rw_csv}
\title{Read RiverWare/RiverSMART produced csv files}
\usage{
read_rw_csv(file)
}
\arguments{
\item{file}{The name of the file which the data are to be read from. Either
an absolute or relative path.}
}
\value{
A tibble (data frame) containing the data in the csv.
}
\description{
\code{read_rw_csv()} reads in a CSV file created from RiverWare. If the CSV
file does not contain column names that RiverWare always uses (see Details),
then it assumes that the CSV file was not created from RiverWare and throws
an error. It also removes spaces from the column names, and adjusts the
\code{Object.Slot} and \verb{Slot Value} columns to be \code{ObjectSlot} and \code{Value},
respectively.
}
\details{
The required column names are: \verb{Run Number}, \verb{Trace Number}, \code{Object.Slot},
\code{Timestep}, \verb{Slot Value}. See the CSV output section of the
\href{http://www.riverware.org/HelpSystem/index.html#page/SolutionApproaches/Solutions_MRM.4.5.html#ww477402}{RiverWare documentation}
for more information on the other optional column names.

This function uses \code{\link[data.table:fread]{data.table::fread()}} to read in
the CSV file, and forces it to expect a CSV file, expect headers, and return
\code{data.frame}.
}
\examples{
zz <- read_rw_csv(system.file(
  "extdata/Scenario/ISM1988_2014,2007Dems,IG,Most",
  "KeySlots.csv",
  package = "RWDataPlyr"
))

}
\seealso{
\code{\link[=read.rdf]{read.rdf()}}
}
