% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_client.R
\name{info_client}
\alias{info_client}
\title{Random walk metrics for each client}
\usage{
info_client(g, data)
}
\arguments{
\item{g}{The input graph. Transactional graph containing the amount (in monetary unit) as the attribute of each edge. The vertices must be the clients IDs.}

\item{data}{Dataframe with information of the clients. It should include a column with the clients IDs named "customer_id" and the alert label named "sar_flag" that must be a boolean variable.}
}
\value{
A dataframe with the clients IDs and the computed metrics (minimum, mean and maximum for both the number of steps and total transactioned amount) for the random walks starting in each client.
}
\description{
Computes the metrics of the generated random walks for every client in the dataframe using the function 'mean_rw_client'.
}
\examples{
g <- igraph::graph_from_data_frame(d = transactions_small_example[, 1:3], directed = TRUE)
info_client(g, data = clients_small_example)

}
\references{
Eddin, A. N., Bono, J., Aparício, D., Polido, D., Ascensao, J. T., Bizarro, P., and Ribeiro, P. (2021). Anti-money laundering alert optimization using machine learning with graphs. arXiv preprint arXiv:2112.07508.
}
