% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rationalMatrix.R
\name{Qrange}
\alias{Qrange}
\title{Range of a rational matrix}
\usage{
Qrange(M)
}
\arguments{
\item{M}{a matrix such that \code{as.character(Mij)} is 
a quoted integer or a quoted fraction for each entry \code{Mij}}
}
\value{
A character matrix representing a basis of the range of \code{M}. 
  Note that this basis is not orthogonal.
}
\description{
Range (column-space, image, span) of a rational matrix.
}
\examples{
library(RationalMatrix)
set.seed(666L)
M <- matrix(rpois(15L, 6), 3L, 5L)
Qrange(M)
}
