% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fastLmPure}
\alias{fastLmPure}
\title{linear model fitting function based on RcppBlaze}
\usage{
fastLmPure(X, y, type)
}
\arguments{
\item{X}{A model matrix.}

\item{y}{A response vector.}

\item{type}{A integer. 0 is QR solver, 1 is LDLT solver, 2 is LLT sovler and 3 is LU solver.}
}
\value{
A list containing coefficients, standard errors, rank of model matrix,
  degree of freedom of residuals, residuals, the standard deviation of random errors and
  fitted values.
}
\description{
\code{fastLmPure} provides the estimates of the linear model based on \strong{RcppBlaze}.
}
\details{
\code{fastLm} estimates the linear model using the \code{solve}.
}
\examples{
# according to fastLm example in RcppArmadillo
data(trees, package="datasets")
flm <- fastLmPure(cbind(1, log(trees$Girth)), log(trees$Volume), 0)
print(flm)
}
