% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcurvep_mergeobj.R
\name{merge_rcurvep_objs}
\alias{merge_rcurvep_objs}
\title{Merge results from multiple rcurvep objects}
\usage{
merge_rcurvep_objs(...)
}
\arguments{
\item{...}{rcurvep objects}
}
\value{
an updated rcurvep object with config = NULL
}
\description{
Sometimes user may want to try multiple curvep setting and pick the one that can capture the shape (wAUC != 0).
The highest absolute wAUC from the chemical-endpoint(-sample_id) pair will be picked.
}
\examples{

data(zfishbeh)

# combine default + mask
out1 <- combi_run_rcurvep(zfishbeh, TRSH = 10)
out2 <- combi_run_rcurvep(zfishbeh, TRSH = 10, mask = 1)
m1 <- merge_rcurvep_objs(out1, out2)

# use same set of samples to combine
out1 <- combi_run_rcurvep(zfishbeh, TRSH = 10, n_samples = 2, seed = 300)
out2 <- combi_run_rcurvep(zfishbeh, TRSH = 10, mask = 1, n_samples = 2, seed = 300)
m1 <- merge_rcurvep_objs(out1, out2)

}
