#' Collection of Survival Datasets (dats)
#'
#' `dats` is a collection of seven survival datasets used for testing and
#' simulation of survival data. These datasets were reconstructed from published
#' Kaplan-Meier survival curves using the widely applied algorithm by Guyot et al. (2012).
#' The datasets were originally sourced from various clinical studies and digitized
#' using WebPlotDigitizer. They are used as benchmarks for synthetic survival data methods,
#' including kernel density estimation, parametric distribution fitting, and bootstrap
#' resampling.
#'
#' @format A list containing 7 data frames. Each data frame includes:
#' \describe{
#'   \item{V1}{Time to event (numeric).}
#'   \item{V2}{Event indicator (0 = censored, 1 = event; numeric).}
#'   \item{V3}{Group identifier (numeric or categorical).}
#' }
#'
#' The datasets in `dats` are:
#' \itemize{
#'   \item **Liang**: Derived from Liang et al. (2019).
#'   \item **Spigel**: Derived from Spigel et al. (2022).
#'   \item **Wu**: Derived from Wu et al. (2015).
#'   \item **Wei**: Derived from Wei et al. (2020).
#'   \item **Lima**: Derived from Lima et al. (2018).
#'   \item **Yoshioka**: Derived from Yoshioka et al. (2019).
#'   \item **Seto**: Derived from Seto et al. (2020).
#' }
#'
#' @source
#' - Maria Thurow et al. (2024). "How to Simulate Realistic Survival Data? A Simulation Study to Compare Realistic Simulation Models"
#'   \emph{arXiv preprint}, \url{https://arxiv.org/abs/2308.07842}.
#' - Original datasets from respective publications (see dataset
#'   documentation for details).
#' - Data reconstructed using the algorithm by Guyot et al. (2012),
#'   \emph{BMC Medical Research Methodology}, \doi{10.1186/1471-2288-12-9}.
#' - Data digitized using WebPlotDigitizer (Rohatgi, A.),
#'   \url{https://automeris.io/WebPlotDigitizer}.
#' @docType data
#' @usage data(dats)
#' @keywords datasets
#' @examples
#' data(dats)
#' names(dats)
#' head(dats$Liang)
"dats"

