% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Variance_bounds.R
\name{Variance_bounds}
\alias{Variance_bounds}
\title{Function to compute the variance bounds for Xnc}
\usage{
Variance_bounds(
  Ldata,
  Rdata,
  out_var,
  c_var,
  nc_var,
  constraint = NULL,
  c_sign = NULL,
  nc_sign = NULL,
  projections = TRUE,
  values,
  sam0,
  refs0,
  nb_pts,
  eps_default,
  nbCores,
  Bsamp = 2000,
  weights_x = NULL,
  weights_y = NULL,
  outside = FALSE,
  alpha = 0.05,
  values_sel = NULL,
  seed = 21
)
}
\arguments{
\item{Ldata}{dataset containing (Y,Xc) where Y is the outcome, Xc are potential common regressors}

\item{Rdata}{dataset containing (Xnc,Xc) where Xnc are the non commonly observed regressors, Xc are potential common regressors}

\item{out_var}{label of the outcome variable Y.}

\item{c_var}{label of the commonly observed regressors Xc.}

\item{nc_var}{label of the non commonly observed regressors Xnc.}

\item{constraint}{vector of the size of X_c indicating the type of constraint if any on f(X_c) : "monotone", "convex", "sign", or "none". Default is NULL, no contraints at all.}

\item{c_sign}{sign restrictions on the commonly observed regressors: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{nc_sign}{sign restrictions on the non-commonly observed regressors Xnc: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{projections}{if FALSE compute the identified set along some directions or the confidence regions. Default is FALSE.}

\item{values}{the different unique points of support of the common regressor Xc.}

\item{sam0}{the directions q to compute the radial function.}

\item{refs0}{indicating the positions in the vector values corresponding to the components of betac.}

\item{nb_pts}{the constant C in DGM for the epsilon_0, the lower bound on the grid for epsilon, taken equal to nb_pts*ln(n)/n. Default is 1 without regressors Xc, 3 with Xc.}

\item{eps_default}{If data_k =NULL, then epsilon is taken equal to eps_default.}

\item{nbCores}{number of cores for the parallel computation. Default is 1.}

\item{Bsamp}{the number of bootstrap/subsampling replications. Default is 1000.}

\item{weights_x}{the sampling weights for the dataset (Xnc,Xc).}

\item{weights_y}{the sampling weights for the dataset (Y,Xc).}

\item{outside}{if TRUE indicates that the parallel computing has been launched outside of the function. Default is FALSE.}

\item{alpha}{for the level of the confidence region. Default is 0.05.}

\item{values_sel}{the selected values of Xc for the conditioning. Default is NULL.}

\item{seed}{set a seed to fix the subsampling replications}
}
\value{
a list containing, in order:
    - ci : a list with all the information on the confidence intervals

    - upper: upper bound of the confidence interval on betanc at level alpha, possibly with sign constraints

    - lower: lower bound upper bound of the confidence interval on betanc, possibly with sign constraints

    - unconstr: confidence interval on betanc, without sign constraints

    - betac_ci: confidence intervals on each coefficients related to the common regressor, possibly with sign constraints

    - betac_ci_unc: confidence intervals on each coefficients related to the common regressor without sign constraints

 - point : a list with all the information on the point estimates

     - upper: the upper bounds on betanc, possibly with sign constraints

     - lower: the lower bounds on betanc, possibly with sign constraints

     -unconstr: bounds on betanc without sign constraints

     -betac_pt: bounds on betanc, possibly with sign constraints

     -betac_pt_unc: bounds on betanc without sign constraints
}
\description{
Function to compute the variance bounds for Xnc
}
