% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegEnRF.R
\name{predict.RegEnRF}
\alias{predict.RegEnRF}
\title{Prediction of test data using Regression-Enhanced Random Forests.}
\usage{
\method{predict}{RegEnRF}(object, newx, ...)
}
\arguments{
\item{object}{an object of class "RegEnRF", as that created by the function RegEnRF}

\item{newx}{matrix of new values for x at which predictions are to be made
function will abort.}

\item{...}{other arguments passed to \link[glmnet:predict.glmnet]{glmnet::predict.glmnet} and
randomForest:::predict.randomForest.}
}
\value{
A vector of predicted values.
}
\description{
Prediction of test data using Regression-Enhanced Random Forests.
}
\examples{
set.seed(111)
x <- matrix(rnorm(100 * 20), 100, 20)
y <- rnorm(100)
mod <- RegEnRF(x, y, lambda = 0.1)
predict(mod, newx = x)
}
