% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dLW.R
\name{dLW}
\alias{dLW}
\alias{pLW}
\alias{qLW}
\alias{rLW}
\alias{hLW}
\title{The Log-Weibull distribution}
\usage{
dLW(x, mu, sigma, log = FALSE)

pLW(q, mu, sigma, lower.tail = TRUE, log.p = FALSE)

qLW(p, mu, sigma, lower.tail = TRUE, log.p = FALSE)

rLW(n, mu, sigma)

hLW(x, mu, sigma)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{sigma}{parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dLW} gives the density, \code{pLW} gives the distribution 
function, \code{qLW} gives the quantile function, \code{rLW}
generates random deviates and \code{hLW} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the Log-Weibull distribution 
with parameters \code{mu} and \code{sigma}.
}
\details{
The Log-Weibull Distribution with parameters \code{mu} 
and \code{sigma} has density given by

\eqn{f(y)=(1/\sigma) e^{((y - \mu)/\sigma)} exp\{-e^{((y - \mu)/\sigma)}\},}

for - \code{infty} < y < \code{infty}.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
curve(dLW(x, mu=0, sigma=1.5), from=-8, to=5,
      col="red", las=1, ylab="f(x)")

## The cumulative distribution and the Reliability function
par(mfrow=c(1, 2))
curve(pLW(x, mu=0, sigma=1.5),
      from=-8, to=5,  col="red", las=1, ylab="F(x)")
curve(pLW(x, mu=0, sigma=1.5, lower.tail=FALSE),
      from=-8, to=5, col="red", las=1, ylab="R(x)")

## The quantile function
p <- seq(from=0, to=0.99999, length.out=100)
plot(x=qLW(p, mu=0, sigma=1.5), y=p, xlab="Quantile",
     las=1, ylab="Probability")
curve(pLW(x, mu=0, sigma=1.5), from=-8, to=5, add=TRUE, col="red")

## The random function
hist(rLW(n=10000, mu=0, sigma=1.5), freq=FALSE,
     xlab="x", las=1, main="")
curve(dLW(x, mu=0, sigma=1.5), from=-15, to=6, add=TRUE, col="red")

## The Hazard function
par(mfrow=c(1,1))
curve(hLW(x, mu=0, sigma=1.5), from=-8, to=7,
      col="red", ylab="Hazard function", las=1)

par(old_par) # restore previous graphical parameters
}
\references{
\insertRef{almalki2014modifications}{RelDists}

\insertRef{Gumbel1958}{RelDists}
}
\author{
Amylkar Urrea Montoya, \email{amylkar.urrea@udea.edu.co}
}
