% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_order_status.R
\name{get_order_status}
\alias{get_order_status}
\title{Get a current status of an order on RobinHood}
\usage{
get_order_status(RH, status_url, limit_output = TRUE)
}
\arguments{
\item{RH}{object of class RobinHood}

\item{status_url}{(string) url of order returned from place_order}

\item{limit_output}{(logical) return limited info on the order (default TRUE)}
}
\description{
Returns a list of order information given a buy/sell order url returned from place_order().
}
\examples{
\dontrun{
# Login in to your RobinHood account
RH <- RobinHood("username", "password")

# Place an order, should generate an email confirmation
x <- place_order(RH = RH,
                 symbol = "GE",          # Ticker symbol you want to trade
                 type = "market",        # Type of market order
                 time_in_force = "gfd",  # Time period the order is good for (gfd: good for day)
                 trigger = "immediate",  # Trigger or delay order
                 price = 8.96,           # The highest price you are willing to pay
                 quantity = 1,           # Number of shares you want
                 side = "buy")           # buy or sell

get_order_status(RH, x$status_url)
}
}
