% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Whereisit.R
\name{Status.planet}
\alias{Status.planet}
\title{Calculate the status of planet
\code{Status.planet}}
\usage{
Status.planet(t, p.orb, ab = 1, r.orb = 1, orig = c(0, 0))
}
\arguments{
\item{t}{Time (day).}

\item{p.orb}{Orbital Period.}

\item{ab}{Semi-major over semi-minor. ab=1 for a Ring.}

\item{r.orb}{Radius of the orbit.}

\item{orig}{Reference orgin.}
}
\value{
(x,y) in Cartesian Coordinate System.
}
\description{
Calculate the status of planet
\code{Status.planet}
}
\examples{
tday = seq(0, 365, 30)
x=Status.planet(t=tday, p.orb = 365, r.orb=10)
plot(PCS2CCS(0:360, a=10), type='l')
plotplanet(orig=x[,-1], rad = .51)
grid()
}
