% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ll_ordered}
\alias{ll_ordered}
\title{Compute ordered probit log-likelihood}
\usage{
ll_ordered(d, y, sys, Tvec)
}
\arguments{
\item{d}{[\code{numeric(J - 2)}]\cr
Threshold increments.}

\item{y}{[\code{matrix(nrow = N, ncol = max(Tvec))}]\cr
Choices \code{1,...,J} for each decider in each choice occasion.}

\item{sys}{[\code{matrix(nrow = N, ncol = max(Tvec))}]\cr
Systematic utilties for each decider in each choice occasion.}

\item{Tvec}{[\code{integer(N)}]\cr
Number of choice occasions per decider.}
}
\value{
The ordered probit log-likelihood value.
}
\description{
Compute ordered probit log-likelihood
}
\examples{
d <- c(0, 0, 0)
y <- matrix(c(1, 2, 1, NA), ncol = 2)
sys <- matrix(c(0, 0, 0, NA), ncol = 2)
Tvec <- c(2, 1)
ll_ordered(d = d, y = y, sys = sys, Tvec = Tvec)

}
\keyword{gibbs_sampler}
