% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.RprobitB_fit.R
\name{transform.RprobitB_fit}
\alias{transform.RprobitB_fit}
\title{Transform fitted probit model}
\usage{
\method{transform}{RprobitB_fit}(
  `_data`,
  B = NULL,
  Q = NULL,
  scale = NULL,
  check_preference_flip = TRUE,
  ...
)
}
\arguments{
\item{_data}{An object of class \code{\link{RprobitB_fit}}.}

\item{B}{[\code{integer(1)}]\cr
The length of the burn-in period.}

\item{Q}{[\code{integer(1)}]\cr
The thinning factor for the Gibbs samples.}

\item{scale}{[\code{character(1)}]\cr
A character which determines the utility scale. It is of the form
\verb{<parameter> := <value>}, where \verb{<parameter>} is either the name of a fixed
effect or \verb{Sigma_<j>,<j>} for the \verb{<j>}th diagonal element of \code{Sigma}, and
\verb{<value>} is the value of the fixed parameter.}

\item{check_preference_flip}{Set to \code{TRUE} to check for flip in preferences after new \code{scale}.}

\item{...}{Currently not used.}
}
\value{
The transformed \code{RprobitB_fit} object.
}
\description{
Given an object of class \code{RprobitB_fit}, this function can:
\itemize{
\item change the length \code{B} of the burn-in period,
\item change the the thinning factor \code{Q} of the Gibbs samples,
\item change the utility \code{scale}.
}
}
\details{
See the vignette "Model fitting" for more details:
\code{vignette("v03_model_fitting", package = "RprobitB")}.
}
