% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratify_spatial.R
\name{stratify_spatial}
\alias{stratify_spatial}
\title{Split data for k-fold spatially stratified cross validation}
\usage{
stratify_spatial(occurrence_sf, nfolds = NULL, nsubclusters = NULL)
}
\arguments{
\item{occurrence_sf}{a sf object containing occurrence points}

\item{nfolds}{number of desired output folds. Default value of NULL makes a reasonable guess based on sample size.}

\item{nsubclusters}{intermediate number of clusters randomly split into nfolds. Default value of NULL makes a reasonable guess based on sample size.
If you specify this manually, it should be an integer multiple of nfolds.}
}
\value{
Returns a SpatialPoints dataframe with the data.frame containing fold designation for each point.
}
\description{
Splitting tool for cross-validation
}
\details{
See Examples.
}
\examples{
{

# load in sample data

 library(S4DM)
 library(terra)
 library(sf)

 # occurrence points
   data("sample_points")
   occurrences <- sample_points


 occurrences <- st_as_sf(x = occurrences,coords = c(1,2))

manual <- stratify_spatial(occurrence_sf = occurrences,nfolds = 5,nsubclusters = 5)
default <- stratify_spatial(occurrence_sf = occurrences)


}
}
\author{
Cory Merow \href{mailto:cory.merow@gmail.com}{cory.merow@gmail.com}
}
