% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_rec_endp.R
\docType{class}
\name{rec_endpoint}
\alias{rec_endpoint}
\title{Azure product recommendations endpoint class}
\format{
An R6 object of class \code{rec_endpoint}.
}
\description{
Class representing the client endpoint to the product recommendations service.
}
\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a client endpoint object. See 'Initialization' for more details.
\item \code{train_model(...)}: Train a new product recommendations model; return an object of class \code{rec_model}. See \code{Training} for more details.
\item \code{get_model(description, id)}: Get an existing product recommendations model from either its description or ID; return an object of class \code{rec_model}.
\item \code{delete_model(description, id)}: Delete the specified model.
\item \code{upload_data(data, destfile)}: Upload a data frame to the endpoint, as a CSV file. By default, the name of the uploaded file will be the name of the data frame with a ".csv" extension.
\item \code{upload_csv(srcfile, destfile)}: Upload a CSV file to the endpoint. By default, the name of the uploaded file will be the same as the source file.
\item \code{sync_model_list()}: Update the stored list of models for this service.
\item \code{get_swagger_url()}: Get the Swagger URL for this service.
\item \code{get_service_url()}: Get the service URL, which is used to train models and obtain recommendations.
}
}

\section{Initialization}{

The following arguments are used to initialize a new client endpoint:
\itemize{
\item \code{name}: The name of the endpoint; see below. Alternatively, this can also be the full URL of the endpoint.
\item \code{admin_key}: The administration key for the endpoint. Use this to retrieve, train, and delete models.
\item \code{rec_key}: The recommender key for the endpoint. Use this to get recommendations.
\item \code{service_host}: The hostname for the endpoint. For the public Azure cloud, this is \code{azurewebsites.net}.
\item \code{storage_key}: The access key for the storage account associated with the service.
\item \code{storage_sas}: A shared access signature (SAS) for the storage account associated with the service. You must provide either \code{storage_key} or \code{storage_sas} if you want to upload new datasets to the backend.
\item \code{storage_host}: The hostname for the storage account. For the public Azure cloud, this is \code{core.windows.net}.
\item \code{storage_endpoint}: The storage account endpoint for the service. By default, uses the account that was created at service creation.
\item \code{data_container}: The default blob container for input datasets. Defaults to \code{"inputdata"}.
}

Note that the name of the client endpoint for a product recommendations service is \emph{not} the name that was supplied when deploying the service. Instead, it is a randomly generated unique string that starts with the service name. For example, if you deployed a service called "myrec", the name of the endpoint is "myrecusacvjwpk4raost".
}

\section{Training}{

To train a new model, supply the following arguments to the \code{train_model} method:
\itemize{
\item \code{description}: A character string describing the model.
\item \code{usage_data}: The training dataset. This is required.
\item \code{catalog_data}: An optional dataset giving features for each item. Only used for imputing cold items.
\item \code{eval_data}: An optional dataset to use for evaluating model performance.
\item \code{support_threshold}: The minimum support for an item to be considered warm.
\item \code{cooccurrence}: How to measure cooccurrence: either user ID, or user-by-time.
\item \code{similarity}: The similarity metric to use; defaults to "Jaccard".
\item \code{cold_items}: Whether recommendations should include cold items.
\item \code{cold_to_cold}: Whether similarities between cold items should be computed.
\item \code{user_affinity}: Whether event type and time should be considered.
\item \code{include_seed_items}: Whether seed items (those already seen by a user) should be allowed as recommendations.
\item \code{half_life}: The time decay parameter for computing user-item affinities.
\item \code{user_to_items}: Whether user ID is used when computing personalised recommendations.
\item \code{wait}: Whether to wait until the model has finished training.
\item \code{container}: The container where the input datasets are stored. Defaults to the input container for the endpoint, usually \code{"inputdata"}.
}

For detailed information on these arguments see the \href{https://github.com/Microsoft/Product-Recommendations/blob/master/doc/api-reference.md#train-a-new-model}{API reference}.
}

\examples{
\dontrun{

# creating a recommendations service endpoint from an Azure resource
svc <- resgroup$get_rec_service("myrec")
rec_endp <- svc$get_rec_endpoint()

# creating the endpoint from scratch -- must supply admin, recommender and storage keys
rec_endp <- rec_endpoint$new("myrecusacvjwpk4raost",
    admin_key="key1", rec_key="key2", storage_key="key3")

# upload the Microsoft store data
data(ms_usage)
rec_endp$upload_data(ms_usage)

# train a recommender
rec_model <- rec_endp$train_model("model1", usage="ms_usage.csv", support_threshold=10,
    similarity="Jaccard", user_affinity=TRUE, user_to_items=TRUE,
    backfill=TRUE, include_seed_items=FALSE)

# list of trained models
rec_endp$sync_model_list()

# delete the trained model (will ask for confirmation)
rec_endp$delete_model("model1")

}
}
\seealso{
\link{az_rec_service} for the service itself, \link{rec_model} for an individual recommmendations model

\href{https://github.com/Microsoft/Product-Recommendations/blob/master/doc/api-reference.md}{API reference} and \href{https://github.com/Microsoft/Product-Recommendations/blob/master/doc/sar.md}{SAR model description} at the Product Recommendations API repo on GitHub
}
