% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta-loading.R
\name{delta_loading}
\alias{delta_loading}
\alias{delta_export}
\alias{delta_load}
\title{Import and export a data-chunk with history from historical data}
\usage{
delta_export(conn, db_table, timestamp_from, timestamp_until = NULL)

delta_load(conn, db_table, delta, logger = NULL)
}
\arguments{
\item{conn}{(\code{DBIConnection(1)})\cr
Connection object.}

\item{db_table}{(\verb{id-like object(1)})\cr
A table specification (coercible by \code{id()}).}

\item{timestamp_from}{(\code{POSIXct(1)}, \code{Date(1)}, or \code{character(1)})\cr
The timestamp describing the start of the export (including).}

\item{timestamp_until}{(\code{POSIXct(1)}, \code{Date(1)}, or \code{character(1)})\cr
The timestamp describing the end of the export (not-including).

If \code{NULL} (default), all history after \code{timestamp_from} is exported.}

\item{delta}{.data (\code{data.frame(1)}, \code{tibble(1)}, \code{data.table(1)}, or \code{tbl_dbi(1)})\cr
A "delta" exported from \code{delta_export()} to load.

A list of "deltas" can also be supplied.}

\item{logger}{(\code{Logger(1)})\cr
A configured logging object. If none is given, one is initialized with default arguments.}
}
\value{
\code{delta_export()} returns a lazy-query containing the data (and history)
in the source to be used in conjunction with \code{delta_load()}.

This table is a temporary table that may need cleaning up.

\code{delta_load()} returns NULL (called for side effects).
}
\description{
\code{delta_export()} exports data from tables created with \code{update_snapshot()}
in chunks to allow for faster migration of data between sources.

\code{delta_load()} import deltas created by \code{delta_export()} to rebuild a
historical table.
}
\details{
This pair of functions is designed to facilitate easy migration or
incremental backups of a historical table (created by \code{update_snapshot()}).

To construct the basis of incremental backups, \code{delta_export()} can be
called with only \code{timestamp_from} at the desired frequency (weekly etc.)

To migrate a historical table in chunks, \code{delta_export()} can be
called with \code{timestamp_until} to constrain the size of the delta.

In either case, the table can then be re-constructed by "replaying" the
deltas with \code{delta_load()}.
The order the deltas are replayed does not matter, but all have to be
replayed to achieve the same state as the source table.
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) withAutoprint(\{ # examplesIf}
  conn <- get_connection()

  data <- dplyr::copy_to(conn, mtcars)

  # Copy the first 3 records
  update_snapshot(
    head(data, 3),
    conn = conn,
    db_table = "test.mtcars",
    timestamp = "2020-01-01"
  )

  # Create a delta with the current state
  delta <- delta_export(
    conn,
    db_table = "test.mtcars",
    timestamp_from = "2020-01-01"
  )

  # Update with the first 5 records
  update_snapshot(
    head(data, 5),
    conn = conn,
    db_table = "test.mtcars",
    timestamp = "2021-01-01"
  )

  dplyr::tbl(conn, "test.mtcars")

  # Create a backup using the delta
  delta_load(
    conn = conn,
    db_table = "test.mtcars_backup",
    delta = delta
  )

  dplyr::tbl(conn, "test.mtcars_backup")

  close_connection(conn)
\dontshow{\}) # examplesIf}
}
\seealso{
update_snapshot
}
