% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ht2info.R
\name{ht2info}
\alias{ht2info}
\title{ht2info}
\usage{
ht2info(HT2, T2matrix, limht2, iobs = NA)
}
\arguments{
\item{HT2}{A vector with values of the Hotelling's T^2_A statistic.}

\item{T2matrix}{A matrix with the contributions of each PC (A columns) for each
observation (rows) to the Hotelling's T^2_A statistic.}

\item{limht2}{Upper Control Limit for the Hotelling's T^2_A statistic, at a certain
confidence
level (1-alpha)*100 \%.}

\item{iobs}{Integer with the index of the observation of interest. Default value
set to \code{NA}.}
}
\value{
ggplot object with the generated bar plots.
}
\description{
Returns information about the Hotelling's T^2 statistic for an observation.
Two subplots show the information of an observation regarding its T^2 statistic,
i.e.: a bar plot indicating the value of the statistic for the observation, and a
bar plot with the contribution that each component had for the T^2 value.
The term T^2_A makes reference to the T^2 for a model with A principal components (PCs).
}
\examples{
X <- as.matrix(X)
pcamodel.ref <- pcamb_classic(X[1:40,], 2, 0.05, "cent") # PCA-MB with first 40 
# observations
pcaproj <- pcame(X[-c(1:40),], pcamodel.ref) # Project last observations
ht2info(pcaproj$T2, pcaproj$T2matrix, pcamodel.ref$limt2, 2) # Information about 
# the T^2 of the row #2
}
