% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_ColorBlindCheck.R
\name{do_ColorBlindCheck}
\alias{do_ColorBlindCheck}
\title{Generate colorblind variations of a given color palette.}
\usage{
do_ColorBlindCheck(
  colors.use,
  flip = FALSE,
  font.size = 14,
  font.type = "sans",
  plot.title.face = "bold",
  plot.subtitle.face = "plain",
  plot.caption.face = "italic",
  axis.title.face = "bold",
  axis.text.face = "plain",
  legend.text.face = "plain",
  legend.title.face = "bold",
  grid.color = "white",
  border.color = "black",
  axis.text.x.angle = 45
)
}
\arguments{
\item{colors.use}{\strong{\code{\link[base]{character}}} | One color upon which generate the color scale. Can be a name or a HEX code.}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{plot.title.face, plot.subtitle.face, plot.caption.face, axis.title.face, axis.text.face, legend.title.face, legend.text.face}{\strong{\code{\link[base]{character}}} | Controls the style of the font for the corresponding theme element.  One of:
\itemize{
\item \emph{\code{plain}}: For normal text.
\item \emph{\code{italic}}: For text in itallic.
\item \emph{\code{bold}}: For text in bold.
\item \emph{\code{bold.italic}}: For text both in itallic and bold.
}}

\item{grid.color}{\strong{\code{\link[base]{character}}} | Color of the grid in the plot. In heatmaps, color of the border of the cells.}

\item{border.color}{\strong{\code{\link[base]{character}}} | Color for the border of the heatmap body.}

\item{axis.text.x.angle}{\strong{\code{\link[base]{numeric}}} | Degree to rotate the X labels. One of: 0, 45, 90.}
}
\value{
A character vector with the desired color scale.
}
\description{
This function generate colorblind variations of a provided color palette in order to check if it is colorblind friendly. Variations are generated using colorspace package.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_ColorBlindCheck", passive = TRUE)
  
  if (isTRUE(value)){
    # Generate a color wheel based on a single value.
    colors <- c("red", "green", "blue")
    p <- SCpubr::do_ColorBlindCheck(colors.use = colors)
    
  } else if (base::isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
