% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coots.R
\docType{data}
\name{coots}
\alias{coots}
\title{coots data}
\format{
This data frame contains the following columns:

\describe{
\item{clutch:}{clutch number from which eggs were subsampled}

\item{csize:}{number of eggs in clutch (\eqn{M_i})}

\item{length:}{length of egg (mm)}

\item{breadth:}{maximum breadth of egg (mm)}

\item{volume:}{calculated as 0.000507*length*\eqn{breadth^2} (\eqn{mm^3})}

\item{tmt:}{

= 1 if received supplemental feeding

= 0 otherwise}
}
}
\usage{
data(coots)
}
\description{
Selected information on egg size, from a larger study by Arnold (1991). Data
provided courtesy of Todd Arnold. Not all observations are used for this data set, so results
may not agree with those in Arnold (1991).
}
\references{
Arnold, T. W. (1991). Intraclutch variation in egg size of American coots. \emph{The Condor 93},
19–27.

Lohr (2021), Sampling: Design and Analysis, 3rd Edition. Boca Raton, FL: CRC Press.

Lu and Lohr (2021), R Companion for \emph{Sampling: Design and Analysis, 3rd Edition}, 1st Edition. Boca Raton, FL: CRC Press.
}
\keyword{datasets}
