% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semFit.R
\name{Shipley.test}
\alias{Shipley.test}
\title{Missing edge testing implied by a DAG with Shipley's basis-set}
\usage{
Shipley.test(
  graph,
  data,
  MCX2 = FALSE,
  cmax = Inf,
  limit = 100,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{graph}{A directed graph as an igraph object.}

\item{data}{A data matrix with subjects as rows and variables as
columns.}

\item{MCX2}{If TRUE, a Monte Carlo P-value of the combined C test is
enabled using the R code of Shipley extracted from 
<https://github.com/BillShipley/CauseAndCorrelation>.}

\item{cmax}{Maximum number of parents set, C. This parameter can be
used to perform only those tests where the number of conditioning
variables does not exceed the given value. High-dimensional conditional
independence tests can be very unreliable. By default, cmax = Inf.}

\item{limit}{An integer value corresponding to the graph size (vcount)
tolerance. Beyond this limit, multicore computation is enabled to
reduce the computational burden. By default, \code{limit = 100}.}

\item{verbose}{If TRUE, Shipley's test results will be showed to
screen (default = TRUE).}

\item{...}{Currently ignored.}
}
\value{
A list of three objects: (i) "dag":  the DAG used to perform the Shipley
test (ii) "dsep": the data.frame of all d-separation tests over missing edges in
the DAG and (iii) "ctest": the overall Shipley's' P-value.
}
\description{
Compute all the P-values of the d-separation tests
implied by the missing edges of a given acyclic graph (DAG).
The conditioning set Z is represented, in a DAG, by the union of the
parent sets of X and Y (Shipley, 2000). 
The results of every test, in a DAG, is then combined using the
Fisher’s statistic in an overall test of the fitted model
C = -2*sum(log(P-value(k))), where C is distributed as a chi-squared
variate with df = 2k, as suggested by Shipley (2000).
}
\examples{

#\donttest{
# Nonparanormal(npn) transformation
als.npn <- transformData(alsData$exprs)$data

sem <- SEMrun(alsData$graph, als.npn)
C_test <- Shipley.test(sem$graph, als.npn, MCX2 = FALSE)
#MC_test <- Shipley.test(sem$graph, als.npn, MCX2 = TRUE)
#}

}
\references{
Shipley B (2000). A new inferential test for path models based on DAGs.
Structural Equation Modeling, 7(2): 206-218.
<https://doi.org/10.1207/S15328007SEM0702_4>
}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
