% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homo.test.R
\name{homo.test}
\alias{homo.test}
\title{User-specified time-homogeneity test}
\usage{
homo.test(
  ts,
  c,
  d,
  m = "MV",
  b_time,
  b_timese,
  mp_type,
  fix_num = 0,
  r = 1,
  s = 1,
  n_point = 4000,
  upper = 10
)
}
\arguments{
\item{ts}{ts is the data set which is a time series data typically}

\item{c}{number of basis for time input}

\item{d}{number of basis for variate input}

\item{m}{the window size for the simultaneous confidence region procedure, with the default being 'MV,' which stands for the Minimum Volatility method}

\item{b_time}{type of basis for time input}

\item{b_timese}{type of basis for variate input}

\item{mp_type}{select type of mapping function, "algeb" indicates algebraic mapping on the real line. "logari" represents logarithmic mapping on the real line}

\item{fix_num}{fix_num indicates fixed value for time}

\item{r}{indicates number of variate}

\item{s}{s is a positive scaling factor, the default is 1}

\item{n_point}{number of points for SCR, the default is 2000}

\item{upper}{upper The upper bound for the variate basis domain. The default value is 10. When "algeb" or "logari" is chosen, the domain is automatically set from -upper to upper}
}
\value{
A list is returned, containing dataframes with three columns each. The first column pertains to input values, the second column contains values of the estimated function
along with their upper and lower bounds, which are used for time-homogeneity testing. The third column serves as a factor indicating the types corresponding to the values in
the second column.
}
\description{
This function utilizes Simultaneous Confidence Regions (SCR) for the automated execution of time-homogeneity tests
}
