% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{SimModel2}
\alias{SimModel2}
\title{Simulate from the type two state-space Model on Stiefel manifold.}
\usage{
SimModel2(iT, mX = NULL, mZ = NULL, mY = NULL, beta_0, alpha,
  mB = NULL, Omega = NULL, vD, burnin = 100)
}
\arguments{
\item{iT}{the sample size.}

\item{mX}{the matrix containing X_t with dimension \eqn{T \times q_1}.}

\item{mZ}{the matrix containing Z_t with dimension \eqn{T \times q_2}.}

\item{mY}{initial values of the dependent variable for \code{ik-1} up to 0. If \code{mY = NULL}, then no lagged dependent variables in regressors.}

\item{beta_0}{the initial beta, iqx+ip*ik, y_{1,t-1},y_{1,t-2},...,y_{2,t-1},y_{2,t-2},....}

\item{alpha}{the \eqn{\alpha} matrix, \eqn{p \times r}.}

\item{mB}{the coefficient matrix \eqn{\boldsymbol{B}} before \code{mZ} with dimension \eqn{p \times q_2}.}

\item{Omega}{covariance matrix of the errors.}

\item{vD}{vector of the diagonals of \eqn{D}.}

\item{burnin}{burn-in sample size (matrix Langevin).}
}
\value{
A list containing the sampled data and the dynamics of beta.

The object is a list containing the following components:
\item{dData}{a data.frame of the sampled data}
\item{aBeta}{an array of the \eqn{\boldsymbol{\beta}_t} with the dimension \eqn{T \times q_1 \times r}}
}
\description{
This function simulates from the type two model on Stiefel manifold.
See Details part below.
}
\details{
The type two model on Stiefel manifold takes the form:
\deqn{\boldsymbol{y}_t \quad = \quad \boldsymbol{\alpha} \boldsymbol{\beta}_t ' \boldsymbol{x}_t + \boldsymbol{B}' \boldsymbol{z}_t + \boldsymbol{\varepsilon}_t}
\deqn{\boldsymbol{\beta}_{t+1} | \boldsymbol{\beta}_{t} \quad \sim \quad ML (q_1, r, \boldsymbol{\beta}_{t} \boldsymbol{D})}
where \eqn{\boldsymbol{y}_t} is a \eqn{p}-vector of the dependent variable,
\eqn{\boldsymbol{x}_t} and \eqn{\boldsymbol{z}_t} are explanatory variables wit dimension \eqn{q_1} and \eqn{q_2},
\eqn{\boldsymbol{x}_t} and \eqn{\boldsymbol{z}_t} have no overlap,
matrix \eqn{\boldsymbol{B}} is the coefficients for \eqn{\boldsymbol{z}_t},
\eqn{\boldsymbol{\varepsilon}_t} is the error vector.

The matrices \eqn{\boldsymbol{\alpha}} and \eqn{\boldsymbol{\beta}_t} have dimensions \eqn{p \times r} and \eqn{q_1 \times r}, respectively.
Note that \eqn{r} is strictly smaller than both \eqn{p} and \eqn{q_1}.
\eqn{\boldsymbol{\alpha}} and \eqn{\boldsymbol{\beta}_t} are both non-singular matrices.
\eqn{\boldsymbol{\beta}_t} is time-varying while \eqn{\boldsymbol{\alpha}} is time-invariant.

Furthermore, \eqn{\boldsymbol{\beta}_t} fulfills the condition \eqn{\boldsymbol{\beta}_t' \boldsymbol{\beta}_t = \boldsymbol{I}_r},
and therefor it evolves on the Stiefel manifold.

\eqn{ML (p, r, \boldsymbol{\beta}_t \boldsymbol{D})} denotes the Matrix Langevin distribution or matrix von Mises-Fisher distribution on the Stiefel manifold.
Its density function takes the form
\deqn{f(\boldsymbol{\beta_{t+1}} ) = \frac{ \mathrm{etr} \left\{ \boldsymbol{D} \boldsymbol{\beta}_{t}' \boldsymbol{\beta_{t+1}} \right\} }{ _{0}F_1 (\frac{p}{2}; \frac{1}{4}\boldsymbol{D}^2 ) }}
where \eqn{\mathrm{etr}} denotes \eqn{\mathrm{exp}(\mathrm{tr}())},
and \eqn{_{0}F_1 (\frac{p}{2}; \frac{1}{4}\boldsymbol{D}^2 )} is the (0,1)-type hypergeometric function for matrix.

Note that the function does not add intercept automatically.
}
\examples{

iT = 50
ip = 2
ir = 1
iqx =3
iqz=2
ik = 1

if(iqx==0) mX=NULL else mX = matrix(rnorm(iT*iqx),iT, iqx)
if(iqz==0) mZ=NULL else mZ = matrix(rnorm(iT*iqz),iT, iqz)
if(ik==0) mY=NULL else mY = matrix(0, ik, ip)

alpha = matrix(c(runif_sm(num=1,ip=ip,ir=ir)), ip, ir)
beta_0 = matrix(c(runif_sm(num=1,ip=ip*ik+iqx,ir=ir)), ip*ik+iqx, ir)
if(ip*ik+iqz==0) mB=NULL else mB = matrix(c(runif_sm(num=1,ip=(ip*ik+iqz)*ip,ir=1)), ip, ip*ik+iqz)
vD = 50

ret = SimModel2(iT=iT, mX=mX, mZ=mZ, mY=mY, alpha=alpha, beta_0=beta_0, mB=mB, vD=vD)

}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{simulation}
