% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_key.R
\name{set_search_key}
\alias{set_search_key}
\title{SP2000 API keys}
\usage{
set_search_key(key, db = "sp2000")
}
\arguments{
\item{key}{\code{string} Value to set apiKey to (i.e. your API key).}

\item{db}{\code{string} Set up the database API, db = c("sp2000","zoology").}
}
\value{
A logical of length one, TRUE is the value was set FALSE if not.
value is returned inside invisible(), i.e. it is not printed to screen
when the function is called.
}
\description{
Apply for the apiKey variable to be used by all search_* functions and zoology_* functions,
register for \url{http://sp2000.org.cn/api/document} and use an API key. This function allows users to set this key.
Note: The daily API visits of ordinary users are 2000,
If you want to apply for increasing the daily API request limit,
please fill in the application form \url{http://col.especies.cn/doc/API.docx} and send an email to \email{SP2000CN@ibcas.ac.cn} entitled "Application for increasing API Request Times".
}
\examples{
\dontrun{
#Set the apiKey variable to be used by all search_* functions
set_search_key("your apiKey",db = "sp2000")

#Set the apiKey variable to be used by all zoology_* functions
set_search_key("your apiKey",db = "zoology")

}
}
\author{
Liuyong Ding \email{ly_ding@126.com}
}
