% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_forecast_compare.R
\name{plot_forecast_compare}
\alias{plot_forecast_compare}
\title{Compare Forecasts from Two Models}
\usage{
plot_forecast_compare(
  forecast1,
  forecast2,
  data_train,
  data_test,
  time,
  quant_high,
  quant_low,
  col1,
  title
)
}
\arguments{
\item{forecast1}{Numeric matrix, forecasted values from the first model (columns: time points).}

\item{forecast2}{Numeric matrix, forecasted values from the second model (columns: time points).}

\item{data_train}{Numeric vector, training data used for modeling.}

\item{data_test}{Numeric vector, actual test data for evaluation.}

\item{time}{Numeric vector, representing the time points corresponding to the data.}

\item{quant_high}{Numeric, upper quantile (e.g., 0.9) for confidence interval.}

\item{quant_low}{Numeric, lower quantile (e.g., 0.1) for confidence interval.}

\item{col1}{Character, color for observed data lines.}

\item{title}{Character, title for the plot.}
}
\value{
A \code{ggplot2} object showing the forecast comparison.
}
\description{
Generates a time series plot comparing the forecasts from two models along with observed data.
}
