% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalSVG_Seurat.R
\name{CalSVG_MarkVario}
\alias{CalSVG_MarkVario}
\title{Detect SVGs using Mark Variogram Method}
\usage{
CalSVG_MarkVario(
  expr_matrix,
  spatial_coords,
  r_metric = 5,
  normalize = TRUE,
  n_threads = 1L,
  verbose = TRUE
)
}
\arguments{
\item{expr_matrix}{Numeric matrix of gene expression values.}

\item{spatial_coords}{Numeric matrix of spatial coordinates.}

\item{r_metric}{Numeric. Distance at which to evaluate the variogram.
Default is 5. Larger values capture broader spatial patterns.}

\item{normalize}{Logical. Whether to normalize the variogram. Default is TRUE.}

\item{n_threads}{Integer. Number of parallel threads. Default is 1.}

\item{verbose}{Logical. Print progress messages. Default is TRUE.}
}
\value{
A data.frame with SVG detection results. Columns:
  \itemize{
    \item \code{gene}: Gene identifier
    \item \code{r.metric.X}: Variogram value at distance r_metric
    \item \code{rank}: Rank by variogram value (ascending, lower = more spatially variable)
  }
}
\description{
Identifies spatially variable genes using the mark variogram approach,
as implemented in Seurat's \code{FindSpatiallyVariableFeatures} function
with \code{selection.method = "markvariogram"}.
}
\details{
\strong{Method Overview:}

The mark variogram measures how the correlation between gene expression
values changes with distance. It is computed using the spatstat package's
\code{markvario} function.

\strong{Interpretation:}
\itemize{
  \item Lower variogram values indicate stronger spatial autocorrelation
  \item Values near 1 indicate random spatial distribution
  \item Values < 1 indicate positive spatial autocorrelation (clustering)
}

\strong{Note:} Requires the \code{spatstat} package suite to be installed:
\code{spatstat.geom} and \code{spatstat.explore}.
}
\examples{
\donttest{
# Load example data
data(example_svg_data)
expr <- example_svg_data$logcounts[1:5, ]
coords <- example_svg_data$spatial_coords

# Requires spatstat packages
if (requireNamespace("spatstat.geom", quietly = TRUE) &&
    requireNamespace("spatstat.explore", quietly = TRUE)) {
    results <- CalSVG_MarkVario(expr, coords, verbose = FALSE)
    head(results)
}
}

}
\references{
Baddeley, A. et al. (2015) Spatial Point Patterns: Methodology and
Applications with R. Chapman and Hall/CRC.
}
\seealso{
\code{\link{CalSVG_Seurat}}
}
