% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_fill_sanger.R
\name{scale_fill_sanger}
\alias{scale_fill_sanger}
\title{Branded discrete colour scale}
\usage{
scale_fill_sanger()
}
\value{
A custom colour filled ggplot2 plot
}
\description{
This anonymous function allows you to apply the Sanger Theme colours to your ggplot2 plot
}
\examples{
library(SangerTools)
library(dplyr)
library(ggplot2)
# Group by Age Band
health_data <- SangerTools::PopHealthData
health_data \%>\%
  dplyr::filter(Smoker == 1) \%>\%
  SangerTools::categorical_col_chart(AgeBand) +
  labs(
    title = "Smoking Population by Age Band",
    subtitle = "Majority of Smokers are Working Aged ",
    x = NULL,
    y = "Patient Number"
  )+
  scale_fill_sanger()
}
