% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcomp.R
\name{pcomp}
\alias{pcomp}
\alias{pcomp.formula}
\alias{pcomp.default}
\alias{print.pcomp}
\alias{summary.pcomp}
\alias{print.summary.pcomp}
\alias{plot.pcomp}
\alias{screeplot.pcomp}
\alias{points.pcomp}
\alias{lines.pcomp}
\alias{text.pcomp}
\alias{biplot.pcomp}
\alias{pairs.pcomp}
\alias{predict.pcomp}
\alias{correlation.pcomp}
\alias{scores}
\alias{scores.pcomp}
\title{Principal Components Analysis.}
\usage{
pcomp(x, ...)

\method{pcomp}{formula}(formula, data = NULL, subset, na.action, method = c("svd", "eigen"), ...)

\method{pcomp}{default}(
  x,
  method = c("svd", "eigen"),
  scores = TRUE,
  center = TRUE,
  scale = TRUE,
  tol = NULL,
  covmat = NULL,
  subset = rep(TRUE, nrow(as.matrix(x))),
  ...
)

\method{print}{pcomp}(x, ...)

\method{summary}{pcomp}(object, loadings = TRUE, cutoff = 0.1, ...)

\method{print}{summary.pcomp}(x, digits = 3, loadings = x$print.loadings, cutoff = x$cutoff, ...)

\method{plot}{pcomp}(
  x,
  which = c("screeplot", "loadings", "correlations", "scores"),
  choices = 1L:2L,
  col = par("col"),
  bar.col = "gray",
  circle.col = "gray",
  ar.length = 0.1,
  pos = NULL,
  labels = NULL,
  cex = par("cex"),
  main = paste(deparse(substitute(x)), which, sep = " - "),
  xlab,
  ylab,
  ...
)

\method{screeplot}{pcomp}(
  x,
  npcs = min(10, length(x$sdev)),
  type = c("barplot", "lines"),
  col = "cornsilk",
  main = deparse(substitute(x)),
  ...
)

\method{points}{pcomp}(
  x,
  choices = 1L:2L,
  type = "p",
  pch = par("pch"),
  col = par("col"),
  bg = par("bg"),
  cex = par("cex"),
  ...
)

\method{lines}{pcomp}(
  x,
  choices = 1L:2L,
  groups,
  type = c("p", "e"),
  col = par("col"),
  border = par("fg"),
  level = 0.9,
  ...
)

\method{text}{pcomp}(
  x,
  choices = 1L:2L,
  labels = NULL,
  col = par("col"),
  cex = par("cex"),
  pos = NULL,
  ...
)

\method{biplot}{pcomp}(x, choices = 1L:2L, scale = 1, pc.biplot = FALSE, ...)

\method{pairs}{pcomp}(
  x,
  choices = 1L:3L,
  type = c("loadings", "correlations"),
  col = par("col"),
  circle.col = "gray",
  ar.col = par("col"),
  ar.length = 0.05,
  pos = NULL,
  ar.cex = par("cex"),
  cex = par("cex"),
  ...
)

\method{predict}{pcomp}(object, newdata, dim = length(object$sdev), ...)

\method{correlation}{pcomp}(x, newvars, dim = length(x$sdev), ...)

scores(x, ...)

\method{scores}{pcomp}(x, labels = NULL, dim = length(x$sdev), ...)
}
\arguments{
\item{x}{A matrix or data frame with numeric data.}

\item{...}{Arguments passed to or from other methods. If \`x` is a
formula one might specify `scale =`, `tol =` or `covmat =`.}

\item{formula}{A formula with no response variable, referring only to numeric
variables.}

\item{data}{An optional data frame (or similar: see [stats::model.frame()])
containing the variables in the formula `formula =`. By default the variables
are taken from `environment(formula)`.}

\item{subset}{An optional vector used to select rows (observations) of the
data matrix `x`.}

\item{na.action}{A function which indicates what should happen when the data
contain `NA`s. The default is set by the `na.action =` setting of
[options()], and is [stats::na.fail()] if that is  not set. The 'factory-fresh'
default is [stats::na.omit()].}

\item{method}{Either `"svd"` (using [stats::prcomp()]), `"eigen"` (using
[stats::princomp()]), or an abbreviation.}

\item{scores}{A logical value indicating whether the score on each principal
component should be calculated.}

\item{center}{A logical value indicating whether the variables should be
shifted to be zero centered. Alternately, a vector of length equal the
number of columns of `x` can be supplied. The value is passed to `scale =`.
Note that this argument is ignored for `method = "eigen"` and the dataset is
always centered in this case.}

\item{scale}{A logical value indicating whether the variables should be
scaled to have unit variance before the analysis takes place. The default is
`TRUE`, which in general, is advisable. Alternatively, a vector of length
equal the number of columns of `x` can be supplied. The value is passed to
[scale()].}

\item{tol}{Only when `method = "svd"`. A value indicating the magnitude
below which components should be omitted. (Components are omitted if their
standard deviations are less than or equal to `tol` times the standard
deviation of the first component.) With the default null setting, no
components are omitted. Other settings for `tol =` could be `tol = 0` or
`tol = sqrt(.Machine$double.eps)`, which would omit essentially constant
components.}

\item{covmat}{A covariance matrix, or a covariance list as returned by
[stats::cov.wt()] (and [MASS::cov.mve()] or [MASS::cov.mcd()] from package **MASS**). If
supplied, this is used rather than the covariance matrix of `x`.}

\item{object}{A 'pcomp' object.}

\item{loadings}{Do we also summarize the loadings?}

\item{cutoff}{The cutoff value below which loadings are replaced by white
spaces in the table. That way, larger values are easier to spot and to read
in large tables.}

\item{digits}{The number of digits to print.}

\item{which}{The graph to plot.}

\item{choices}{Which principal axes to plot. For 2D graphs, specify two
integers.}

\item{col}{The color to use in graphs.}

\item{bar.col}{The color of bars in the screeplot.}

\item{circle.col}{The color for the circle in the loadings or correlations
plots.}

\item{ar.length}{The length of the arrows in the loadings and correlations
plots.}

\item{pos}{The position of text relative to arrows in loadings and
correlation plots.}

\item{labels}{The labels to write. If `NULL` default values are computed.}

\item{cex}{The factor of expansion for text (labels) in the graphs.}

\item{main}{The title of the graph.}

\item{xlab}{The label of the x-axis.}

\item{ylab}{The label of the y-axis.}

\item{npcs}{The number of principal components to represent in the screeplot.}

\item{type}{The type of screeplot (`"barplot"` or `"lines"`) or pairs plot
(`"loadings"` or `"correlations"`).}

\item{pch}{The type of symbol to use.}

\item{bg}{The background color for symbols.}

\item{groups}{A grouping factor.}

\item{border}{The color of the border.}

\item{level}{The probability level to use to draw the ellipse.}

\item{pc.biplot}{Do we create a Gabriel's biplot (see [stats::biplot()])?}

\item{ar.col}{Color of arrows.}

\item{ar.cex}{Expansion factor for terxt on arrows.}

\item{newdata}{New individuals with observations for the same variables as
those used for calculating the PCA. You can then plot these additional
individuals in the scores plot.}

\item{dim}{The number of principal components to keep.}

\item{newvars}{New variables with observations for same individuals as those
used for mcalculating the PCA. Correlation with PCs is calculated. You can
then plot these additional variables in the correlation plot.}
}
\value{
A `c("pcomp", "pca", "princomp")` object.
}
\description{
Perform a principal components analysis on a matrix or data frame and return
a `pcomp` object.
}
\details{
`pcomp()` is a generic function with `"formula"` and `"default"`
methods. It is essentially a wrapper around [stats::prcomp()] and [stats::princomp()] to
provide a coherent interface and object for both methods.

A 'pcomp' object is created. It inherits from 'pca' (as in **labdsv**
package, but not compatible with the 'pca' object of package **ade4**) and of
'princomp'.

For more information on calculation done, refer to [stats::prcomp()] for
`method = "svd"` or [stats::princomp()] for `method = "eigen"`.
}
\note{
The signs of the columns of the loadings and scores are arbitrary, and
so may differ between functions for PCA, and even between different builds of
\R.
}
\examples{
# We will analyze mtcars without the Mercedes data (rows 8:14)
data(mtcars)
cars.pca <- pcomp(~ mpg + cyl + disp + hp + drat + wt + qsec, data = mtcars,
  subset = -(8:14))
cars.pca
summary(cars.pca)
screeplot(cars.pca)

# Loadings are extracted and plotted like this
(cars.ldg <- loadings(cars.pca))
plot(cars.pca, which = "loadings") # Equivalent to vectorplot(cars.ldg)

# Similarly, correlations of variables with PCs are extracted and plotted
(cars.cor <- Correlation(cars.pca))
plot(cars.pca, which = "correlations") # Equivalent to vectorplot(cars.cor)
# One can add supplementary variables on this graph
lines(Correlation(cars.pca,
  newvars = mtcars[-(8:14), c("vs", "am", "gear", "carb")]))

# Plot the scores
plot(cars.pca, which = "scores", cex = 0.8) # Similar to plot(scores(x)[, 1:2])
# Add supplementary individuals to this plot (labels), also points() or lines()
text(predict(cars.pca, newdata = mtcars[8:14, ]), col = "gray", cex = 0.8)

# Pairs plot for 3 PCs
iris.pca <- pcomp(iris[, -5])
pairs(iris.pca, col = (2:4)[iris$Species])
}
\seealso{
[vectorplot()], [stats::prcomp()], [stats::princomp()], [stats::loadings()],
[SciViews::Correlation()]
}
\author{
Philippe Grosjean <phgrosjean@sciviews.org>, but the core code is
indeed in package **stats**.
}
\concept{principal component analysis and biplot}
\keyword{models}
