% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SentimentDictionary.R
\name{summary.SentimentDictionaryWordlist}
\alias{summary.SentimentDictionaryWordlist}
\alias{summary.SentimentDictionaryBinary}
\alias{summary.SentimentDictionaryWeighted}
\title{Output summary information on sentiment dictionary}
\usage{
\method{summary}{SentimentDictionaryWordlist}(object, ...)

\method{summary}{SentimentDictionaryBinary}(object, ...)

\method{summary}{SentimentDictionaryWeighted}(object, ...)
}
\arguments{
\item{object}{Sentiment dictionary of type \code{\link{SentimentDictionaryWordlist}}, 
\code{\link{SentimentDictionaryBinary}} or \code{\link{SentimentDictionaryWeighted}}}

\item{...}{Additional parameters passed to specific sub-routines}
}
\description{
Output summary information on sentiment dictionary
}
\examples{
summary(SentimentDictionary(c("uncertain", "possible", "likely")))
summary(SentimentDictionary(c("increase", "rise", "more"),
                            c("fall", "drop")))
summary(SentimentDictionary(c("increase", "decrease", "exit"),
                            c(+1, -1, -10),
                            rep(NA, 3)))
}
\seealso{
\code{\link{print}} for output the entries of a dictionary
}
\keyword{dictionary}
