% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Block_permutation.R
\name{block.permut}
\alias{block.permut}
\title{Block permutation of the temporal component in a spatio-temporal point pattern}
\usage{
block.permut(nblocks, X, nperm = 1999)
}
\arguments{
\item{nblocks}{Integer (>= 2). Number of consecutive temporal blocks after ordering events by time.}

\item{X}{Numeric matrix or data frame with at least three columns \code{(x, y, t)}. Each row represents one event.
The third column is interpreted as the time coordinate.}

\item{nperm}{Integer (>= 1). Number of permuted datasets to generate. At most
\code{factorial(nblocks) - 1} distinct non-identity block permutations exist.}
}
\value{
A list of length \code{min(nperm, factorial(nblocks) - 1)}. Each element is a matrix with the same
number of columns as \code{X}; the third column contains the block-permuted time values.
}
\description{
Permutes the temporal component of a spatio-temporal dataset in a block-wise manner while keeping
the spatial coordinates fixed. This is used to generate permuted replicates under the null model
of first-order separability.
}
\details{
The function first orders the events by time and partitions the ordered sequence into
\code{nblocks} consecutive blocks of equal size. The block labels are permuted (excluding the identity
permutation), and the time values are reassigned according to the permuted block order.

If \code{nrow(X)} is not divisible by \code{nblocks}, the last \code{nrow(X) \%\% nblocks} events are not
included in the block permutation and are appended unchanged to each permuted dataset.

For details of the block permutation procedure, see the Supplementary Materials in
Ghorbani et al. (2025).

Note that the \code{\link{sim.procedures}} covers both pure and block permutation methods.
}
\examples{

set.seed(123)
X <- cbind(runif(100), runif(100), runif(100, 0, 10))
perms <- block.permut(nblocks = 5, X = X, nperm = 10)
head(perms[[1]], 5)

}
\references{
Ghorbani, M., Vafaei, N. and Myllymäki, M. (2025). A kernel-based test for the first-order separability
of spatio-temporal point processes, \emph{TEST}.
}
\seealso{
\code{\link{sim.procedures}}
}
