% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.exposure.r
\name{sim.exposure}
\alias{sim.exposure}
\title{Create Simulated Exposure Matrix for Real and Observed Data}
\usage{
sim.exposure(exposed.matrix, params)
}
\arguments{
\item{exposed.matrix}{Output exposure matrix from create.exposure function.}

\item{params}{Output from initialize.data function.}
}
\description{
This function creates an exposure matrix with real and observed data 
after taking into account true positive, false negative, and false 
positive rates. The columns represent strata for the observational data #' and the rows represent new events in unit time. Do not run sim.exposure
as a stand-alone function.
}
\examples{
paramtest <- initialize.data(seed=8768, N=1, t0=0, tf=2, NStrata=2, 
strataRatio=c(0.2, 0.3, 0.3, 0.2), EventRate=c(0.4, 0.5), sensitivity=0.9, PPVest=0.9, RR=3.0, 
MatchRatio=1, maxSampleSize=200, maxTest=1, totalAlpha=0.05, minEvents=5, AlphaSpendType="Wald",
AlphaParameter=0.5, address=getwd(), rate=20, offset=30)
exposed1 <- create.exposure(paramtest)
sim.exposure(exposed1, paramtest)
}
\keyword{sequential}
